from datacloud.model_applyer.lib import features_v2 as features
# from datacloud.model_applyer.lib import general_features


__all__ = [
    'all_features'
]


__base_features = [
    features.DSSMFeature,
    features.ClusterFeature,
    features.ContactActionFeature,
    features.TimeHistFeature,
    features.PhoneRangeFeature,
    features.LocationsFeature,
]

__all_features = __base_features + [
    # general_features.DSSMFeatureBase400,
    # general_features.ClusterFeatureBase763,
    # general_features.ClusterFeatureBase767,
    # general_features.NormedS2VFeatureBase512,
    # general_features.GeoFeatureBase18,
]

all_features = {
    feature.__name__: feature for feature in __all_features
}
all_features['DSSMFeatureBase400'] = features.DSSMFeature
all_features['ClusterFeatureBase767'] = features.ClusterFeature
all_features['NormedS2VFeatureBase512'] = features.NormedS2VFeature

base_features = {
    feature().feature_name: feature for feature in __base_features
}
