import yt.wrapper as yt_wrapper
from datacloud.dev_utils.yt import yt_utils
from datacloud.model_applyer.lib.applyer import SingleModelApplyer
from datacloud.model_applyer.tables.apply_history_table import ApplyHistoryTable


def run_model(model_class, model_config, yt_client,
              is_get_features=True, is_apply_model=True, date_str=None,
              combined_features_table_path=None):
    if date_str is not None:
        model_config.date_str = date_str
    yt_utils.create_folders([model_config.score_dir, model_config.tmp_dir], yt_client)

    models_dict = {
        model_config.score_name: model_class(
            model_name=model_config.score_name,
            binary_path=model_config.binary_path,
            is_local=model_config.is_local,
            date_str=model_config.date_str,
            score_name=model_config.score_name,
            save_info=model_config.is_save_info
        )
    }

    combined_features_table_path = combined_features_table_path or \
        yt_wrapper.ypath_join(model_config.tmp_dir, 'combined-features')

    model_applyer = SingleModelApplyer(
        models_dict=models_dict,
        # features_list=[feature() for feature in model_config.required_features],
        features_list=model_config.required_features,
        combined_features_table=combined_features_table_path,
        result_scores_table=yt_wrapper.ypath_join(model_config.score_dir,
                                                  model_config.date_str))
    if is_get_features:
        model_applyer.get_features(yt_client, date_str)
    if is_apply_model:
        model_applyer.apply(yt_client)
        ApplyHistoryTable().add_applied_model(model_config)
    return model_applyer.result_scores_table
