import sys
from yt.wrapper import YtClient
from datacloud.config.yt import YT_PROXY
from datacloud.money.fast_logs.money_pipeline import calculate_fast_logs_money
from datacloud.money.pipeline_helpers import DAYS_TO_POST


def main():
    assert len(sys.argv) < 3, 'Too many positional arguments!'
    days_to_post = DAYS_TO_POST
    if len(sys.argv) > 1:
        days_to_post = int(sys.argv[1])

    yt_client = YtClient(YT_PROXY)
    calculate_fast_logs_money(yt_client, days_to_post=days_to_post)


if __name__ == '__main__':
    main()
