# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_config_table

PRICE_POLICY_TABLE_PATH = '//home/x-products/production/datacloud/money/price_policy'


class PricePolicyTable(yt_config_table.ConfigTable):
    def __init__(self, table_path=PRICE_POLICY_TABLE_PATH, yt_client=None):
        schema = [
            {'name': 'partner_id', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'contract_id', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'is_active', 'type': 'boolean'},
            {'name': 'policy', 'type': 'any'},
            {'name': 'additional', 'type': 'any'}
        ]
        super(PricePolicyTable, self).__init__(
            table_path, schema, yt_client
        )

    def add_policy(self, partner_id, contract_id, policy, is_active=True, additional=None):
        additional = additional or {}

        record = {
            'partner_id': partner_id,
            'contract_id': contract_id,
            'is_active': is_active,
            'policy': policy,
            'additional': additional
        }
        self.insert_records([record])

    def get_policy(self, partner_id, contract_id):
        return self.get_record_by_params({
            'partner_id': partner_id,
            'contract_id': contract_id
        })

    def turn_on(self, partner_id, contract_id):
        model = self.get_policy(partner_id, contract_id)
        model['is_active'] = True
        self.insert_records([model])
