import sys
from yt.wrapper import YtClient
from datacloud.config.yt import YT_PROXY
from datacloud.money.qloud_logs.money_pipeline import calculate_money
from datacloud.launcher.lib.routines.score_api_aggregates_routine import build_score_api_aggregates
from datacloud.money.pipeline_helpers import DAYS_TO_POST


def main():
    assert len(sys.argv) < 3, 'Too many positional arguments!'
    days_to_post = DAYS_TO_POST
    if len(sys.argv) > 1:
        days_to_post = int(sys.argv[1])

    yt_client = YtClient(YT_PROXY)
    build_score_api_aggregates(seconds_thresh=0)
    calculate_money(yt_client, days_to_post=days_to_post)


if __name__ == '__main__':
    main()
