# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_config_table

SCORE_TO_CONTRACT_TABLE_PATH = '//home/x-products/production/datacloud/money/score_to_contract'


class ScoreToCotractTable(yt_config_table.ConfigTable):
    def __init__(self, table_path=SCORE_TO_CONTRACT_TABLE_PATH, yt_client=None):
        schema = [
            {'name': 'partner_id', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_name', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'first_month', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'last_month', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'contract_id', 'type': 'string'},
            {'name': 'additional', 'type': 'any'}
        ]
        super(ScoreToCotractTable, self).__init__(
            table_path, schema, yt_client
        )

    def add_record(self, partner_id, score_name, contract_id, first_month, last_month=None, additional=None):
        additional = additional or {}

        record = {
            'partner_id': partner_id,
            'score_name': score_name,
            'first_month': first_month,
            'last_month': last_month,
            'contract_id': contract_id,
            'additional': additional
        }
        self.insert_records([record])

    def get_contract_id(self, partner_id, score_name, first_month, last_month=None):
        return self.get_record_by_params({
            'partner_id': partner_id,
            'score_name': score_name,
            'first_month': first_month,
            'last_month': last_month
        })
