PY2_LIBRARY(api)

OWNER(
    g:xprod
    re9ulusv
)

PY_SRCS(
    app.py
    auth.py
    errors.py
    test_run_app.py

    blueprints/__init__.py
    blueprints/score_api.py

    blueprints/views/__init__.py
    blueprints/views/geo_score.py
    blueprints/views/score.py
    blueprints/views/ydb_reject.py
    blueprints/views/ydb_score.py
    blueprints/views/ydb_stability.py

    gunicorn_app.py
)

PEERDIR(
    datacloud/crypta_utils
    datacloud/logging
    datacloud/dev_utils
    datacloud/dev_utils/geo
    datacloud/dev_utils/tvm
    datacloud/dev_utils/id_value
    datacloud/dev_utils/ydb/lib/core

    datacloud/score_api/storage/cookie_sync
    datacloud/score_api/storage/ydb/ydb_tables
    datacloud/score_api/storage/crypta
    datacloud/score_api/storage/cache
    datacloud/score_api/storage/scores
    datacloud/score_api/storage/geo
    datacloud/score_api/storage/users
    datacloud/score_api/storage/rejected
    datacloud/score_api/storage/stability
    datacloud/score_api/storage/score_path
    datacloud/score_api/validators

    contrib/python/click
    contrib/python/Flask
    contrib/python/gunicorn
    contrib/python/jsonschema
    contrib/python/requests
    contrib/python/responses
    contrib/python/transfer_manager_client  # remove ?

    ydb/public/sdk/python
    maps/doc/proto/yandex/maps/proto/common2  # Do not remove! Leads to import error! (don't know why)
)

END()
