import os
import sys
from datacloud.score_api.storage.cookie_sync.cookie_sync_api import CookieSyncApi
from datacloud.score_api.storage.cookie_sync.optimistic import OptimisticCookieSyncSet


def main():
    is_prod = os.environ.get('IS_PROD', False)
    try:
        vendor, cookie = sys.argv[1], sys.argv[2]
    except:
        print('Usage: {} vendor cookie'.format(sys.argv[0]))
        return 1
    api = CookieSyncApi(OptimisticCookieSyncSet(), is_prod=is_prod)
    cookie = {'cookie_vendor': vendor, 'cookie': cookie}
    matches = api.get_matches(cookie)  # api.get_matches_v2(cookie)
    print('Matches are: {}'.format(matches))

    api_answer = api.lookup_cids([cookie])
    print('CidV2: {}'.format(api_answer))


if __name__ == '__main__':
    main()
