# -*- coding: utf-8 -*-


__all__ = [
    'CookieSyncSet'
]


class CookieSyncSet(object):
    """
    Base class for cookie sync set
    """
    def is_sync_cookie(self, cookie_vendor):
        """ Returns True if cookie_vendor is acceptable for cookie-sync and false otherwise
        vendor ([str,]): list of cookie vendors that supports cookie-sync"""
        raise NotImplementedError()

    def check_multiple_cookies_for_sync(self, cookie_list):
        """ Returns list of cookies from cookies list that supports cookie-matching
        `cookie_list` is list of dicts like [{'cookie_vendor': '...', 'cookie': '...'},]"""
        raise NotImplementedError()
