# -*- coding: utf-8 -*-
from datacloud.score_api.storage.cookie_sync.generic import CookieSyncSet


class OptimisticCookieSyncSet(CookieSyncSet):
    def __init__(self):
        super(CookieSyncSet, self).__init__()

    def is_sync_cookie(self, cookie):
        return True

    def check_multiple_cookies_for_sync(self, cookie_list):
        """ Returns list of cookies from cookies list that supports cookie-matching
        `cookie_list` is list of dict like [{'cookie_vendor': '...', 'cookie': '...'},]"""
        return [cookie for cookie in cookie_list]  # [cookie for cookie in cookie_list if cookie['cookie_vendor'] in self._vendors]
