# -*- coding: utf-8 -*-
from datacloud.score_api.storage.cookie_sync.generic import CookieSyncSet


__all__ = [
    'SimpleCookieSyncSet'
]


class SimpleCookieSyncSet(CookieSyncSet):
    def __init__(self, vendor_list):
        """
        Args:
            vendor ([str,]): list of cookie vendors that supports cookie-sync
        """
        super(CookieSyncSet, self).__init__()
        self._vendors = frozenset(vendor_list)

    def is_sync_cookie(self, cookie):
        """ Returns list of cookies from cookies list that supports cookie-matching
        `cookies` is dict like {'cookie_vendor': '...', 'cookie': '...'}
        """
        return cookie['cookie_vendor'] in self._vendors

    def check_multiple_cookies_for_sync(self, cookie_list):
        """ Returns list of cookies from cookies list that supports cookie-matching
        `cookie_list` is list of dict like [{'cookie_vendor': '...', 'cookie': '...'},]"""
        return [cookie for cookie in cookie_list if cookie['cookie_vendor'] in self._vendors]
