# -*- coding: utf-8 -*-
import datetime
import calendar
from datacloud.score_api.storage.ydb.ydb_tables.rejected_tables.rejected_requests_table import RejectedRequestsTable


__all__ = [
    'YdbRejectedRequestsStorage'
]


class YdbRejectedRequestsStorage:
    """
    Rejected requests info in YandexDataBase
    """
    def __init__(self, ydb_manager, database, table_path):
        self._ydb_manager = ydb_manager
        self._database = database
        self._table_path = table_path
        self._rejected_table = None

    @property
    def rejected_table(self):
        if self._rejected_table is None:
            self._rejected_table = RejectedRequestsTable(self._ydb_manager, self._database, self._table_path)
        return self._rejected_table

    # TODO: Test
    def get_rejected_request(self, partner_id, score_id, request_id):
        return self.rejected_table.get_one(RejectedRequestsTable.Record(partner_id, score_id, request_id))

    # TODO: Test
    def reject_request(self, partner_id, score_id, request_id, request_timestamp):
        record = RejectedRequestsTable.Record(partner_id, score_id, request_id, request_timestamp,
                                              calendar.timegm(datetime.datetime.now().utctimetuple()))
        self.rejected_table.insert([record])
