
from collections import namedtuple


__all__ = [
    'Score',
    'ScoreValue',
    'ScoresStorage',
]


class Score(object):
    """ Single score """

    def __init__(self, partner_id, name):
        super(Score, self).__init__()
        self.partner_id = partner_id
        self.name = name


ScoreValue = namedtuple('ScoreValue', 'name value')


class ScoresStorage(object):
    """ Base class for accessing to scores """

    def get_user_scores(self, user):
        """
        Returs list of Score
        """
        raise NotImplementedError()

    def get_scores_value(self, partner, cids, scores):
        """
        Returns list of ScoreValue for given crypta ids
        """
        raise NotImplementedError()
