# -*- coding: utf-8 -*-
from datacloud.score_api.storage.ydb.ydb_tables.stability_tables.stability_table import StabilityTable


__all__ = [
    'YdbStabilityStorage'
]


class YdbStabilityStorage:
    """
    Stability that stores info in YandexDataBase
    """
    def __init__(self, ydb_manager, database, table_path):
        self._ydb_manager = ydb_manager
        self._database = database
        self._table_path = table_path
        self._stability_table = None

    @property
    def stability_table(self):
        if self._stability_table is None:
            self._stability_table = StabilityTable(self._ydb_manager, self._database, self._table_path)
        return self._stability_table

    def get_stability(self, date, partner_id, score_id, segment):
        stability_rec = self.stability_table.get_one(StabilityTable.Record(date, partner_id, score_id, segment))
        if not stability_rec:
            return None
        return stability_rec.stability
