
from flask_login import UserMixin


class User(UserMixin, object):
    """ Service external user """

    def __init__(self, id):
        super(User, self).__init__()
        self.id = id


class UserStorage(object):
    """
    Base class for retriving users info
    """

    def get_user_by_token(self, token, address=None):
        """ Returns `User` associated with given token """
        raise NotImplementedError()
