from .generic import User


class SimpleUserStorage(object):
    """
    Simple user storage returning users from memory
    """

    def __init__(self, users, **kwargs):
        """ users is a dict {token => login}"""
        super(SimpleUserStorage, self).__init__(**kwargs)
        self._users = users

    def get_user_by_token(self, token, address=None):
        """ Returns `User` associated with given token """
        if token not in self._users:
            return None
        return User(id=self._users[token])
