import os
from datacloud.dev_utils.ydb.lib.core.utils import get_ydb_driver
from datacloud.score_api.storage.ydb import ydb_tables
from datacloud.score_api.storage.ydb import utils as ydb_utils


def create_tables(ydb_manager, tables_to_create, database_path):
    """
    Args:
        tables_to_create([YdbTable, table_path]): where YdbTable is child class of YdbTable and table_path is str path of table.
        session
    """
    for TableClass, table_path in tables_to_create:
        table = TableClass(ydb_manager, database_path, table_path)
        table.create()


def create_score_tables(ydb_manager, database_path, score_folder):
    ydb_utils.create_folder(ydb_manager.driver.driver, database_path, score_folder)
    tables_to_create = [
        (ydb_tables.score_tables.MetaScoreTable, os.path.join(score_folder, 'score')),
    ]
    create_tables(ydb_manager, tables_to_create, database_path)


def create_datacloud.score_api_config_tables(ydb_manager, database_path, config_folder):
    ydb_utils.create_folder(ydb_manager.driver.driver, database_path, config_folder)
    tables_to_create = [
        (ydb_tables.config_tables.PartnerScoresTable, os.path.join(config_folder, 'partner_scores')),
        (ydb_tables.config_tables.PartnerTokensTable, os.path.join(config_folder, 'partner_tokens')),
        (ydb_tables.config_tables.ScorePathTable, os.path.join(config_folder, 'score_path'))
    ]
    create_tables(ydb_manager, tables_to_create, database_path)


def create_stability_table(ydb_manager, database_path, stability_folder):
    ydb_utils.create_folder(ydb_manager.driver.driver, database_path, stability_folder)
    tables_to_create = [
        (ydb_tables.stability_tables.StabilityTable, os.path.join(stability_folder, 'stability')),
    ]
    create_tables(ydb_manager, tables_to_create, database_path)


def create_geo_tables(ydb_manager, database_path, ydb_path_config):
    ydb_utils.create_folder(ydb_manager.driver.driver, database_path, ydb_path_config.config_dir)
    tables_to_create = [
        (ydb_tables.config_tables.GeoPathTable, ydb_path_config.geo_path_table_path),
        (
            ydb_tables.geo_tables.geo_logs_table.GeoLogsTable,
            os.path.join(ydb_path_config.geo_root_path, 'test-geo-logs-table'),
        ),
        (
            ydb_tables.score_tables.crypta_table.CryptaTable,
            os.path.join(ydb_path_config.geo_root_path, 'test-crypta-table'),
        ),
    ]
    create_tables(ydb_manager, tables_to_create, database_path)


def create_sandbox_score_tables(ydb_manager, database, root_path):
    score_tables_list = [
        ('partner_a', 'score_a'),
        ('partner_a', 'score_b'),
        ('partner_a', 'score_c'),
        ('partner_b', 'score_a'),
        ('partner_b', 'score_b'),
        ('partner_b', 'score_c'),
        ('partner_c', 'score_a'),
        ('partner_c', 'score_b'),
        ('partner_c', 'score_c'),
    ]
    date = 'date-23-10-2018'
    for partner, score in score_tables_list:
        create_score_tables(ydb_manager, database, os.path.join(root_path, 'scores', partner, score, date))


def create_rejected_requests_table(ydb_manager, database, rejected_folder):
    ydb_utils.create_folder(ydb_manager.driver.driver, database, rejected_folder)
    tables_to_create = [
        (ydb_tables.rejected_tables.RejectedRequestsTable, os.path.join(rejected_folder, 'rejected_requests')),
    ]
    create_tables(ydb_manager, tables_to_create, database)


def create_prod_env(ydb_manager, database, root_path):
    create_datacloud.score_api_config_tables(ydb_manager, database, os.path.join(root_path, 'config'))


def add_partner_score(ydb_manager, databae, root_path):
    raise NotImplementedError()


if __name__ == '__main__':
    endpoint = 'ydb-ru.yandex.net:2135'
    database = '/ru/impulse/production/xprod-scoring-api-db'
    path = ''
    root_path = 'score_api'

    # TODO: Remove auth_token
    auth_token = os.environ['YDB_TOKEN']

    driver = get_ydb_driver(endpoint, database, auth_token)
    # create_prod_env(driver, database, root_path)
    date = '2018-11-30'
    create_score_tables(driver, database, os.path.join(root_path, 'scores', 'ubrr', 'ubrr_xprod_936_fraud', date))
