# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_config_table
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.dev_utils.time.utils import assert_date_str

logger = get_basic_logger(__name__)
DEFAULT_PATH = '//home/x-products/production/datacloud/stability/batch_monitoring/batch_monitoring_log_new_temporary'


__all__ = [
    'BatchMonitoringLogTable'
]


class BatchMonitoringLogTable(yt_config_table.ConfigTable):
    PURE_CRYPTA_TYPE = 'pure'
    BLENDED_CRYPTA_TYPE = 'blended'

    def __init__(self, table_path=DEFAULT_PATH, yt_client=None):
        schema = [
            {'name': 'partner_id', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_name', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_date', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_type', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'crypta_type', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'batch_name', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'AUC', 'type': 'double'},
            {'name': 'hit', 'type': 'double'},
            {'name': 'test_batch', 'type': 'string'},
            {'name': 'score_table', 'type': 'string'},
            {'name': 'timestamp', 'type': 'string'},
            {'name': 'additional', 'type': 'any'},
        ]

        super(BatchMonitoringLogTable, self).__init__(
            table_path, schema, yt_client
        )

    def add_record(self, partner_id, score_date, score_name, score_type, crypta_type,
                   batch_name, AUC, hit, test_batch, score_table, timestamp, additional=None):

        assert_date_str(score_date)
        additional = additional or {}

        record = {
            'partner_id': partner_id,
            'score_name': score_name,
            'score_date': score_date,
            'score_type': score_type,
            'crypta_type': crypta_type,
            'batch_name': batch_name,
            'AUC': AUC,
            'hit': hit,
            'test_batch': test_batch,
            'score_table': score_table,
            'timestamp': timestamp,
            'additional': additional
        }
        self.insert_records([record])

    def get_record(self, partner_id, date_str, score_name, score_type, crypta_type,
                   batch_name):
        return self.get_record_by_params({
            'partner_id': partner_id,
            'score_date': date_str,
            'score_name': score_name,
            'score_type': score_type,
            'crypta_type': crypta_type,
            'batch_name': batch_name
        })
