# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_config_table
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.dev_utils.time.utils import assert_date_str


logger = get_basic_logger(__name__)
DEFAULT_PATH = '//home/x-products/production/datacloud/stability/crypta_stability/api_log'


__all__ = [
    'CryptaStabilityLogTable'
]


class CryptaStabilityLogTable(yt_config_table.ConfigTable):
    def __init__(self, table_path=DEFAULT_PATH, yt_client=None):
        schema = [
            {'name': 'partner_id', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_name', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'crypta_date', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_date', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'eids_count_input', 'type': 'int64'},
            {'name': 'eids_count', 'type': 'int64'},
            {'name': 'hit', 'type': 'double'},
            {'name': 'success', 'type': 'boolean'},
            {'name': 'additional', 'type': 'any'},
        ]
        super(CryptaStabilityLogTable, self).__init__(
            table_path, schema, yt_client
        )

    def add_record(
            self, partner_id, score_name, crypta_date, score_date,
            eids_count_input, eids_count, hit, success, additional=None):

        assert_date_str(crypta_date)
        assert_date_str(score_date)
        additional = additional or {}

        record = {
            'partner_id': partner_id,
            'score_name': score_name,
            'crypta_date': crypta_date,
            'score_date': score_date,
            'eids_count_input': eids_count_input,
            'eids_count': eids_count,
            'hit': hit,
            'success': success,
            'additional': additional
        }
        self.insert_records([record])
