# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_config_table
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.dev_utils.time.utils import assert_date_str


logger = get_basic_logger(__name__)
DEFAULT_PATH = '//home/x-products/production/datacloud/stability/crypta_stability/cids_log'


__all__ = [
    'CryptaStabilityCidsTable'
]


class CryptaStabilityCidsTable(yt_config_table.ConfigTable):
    def __init__(self, table_path=DEFAULT_PATH, yt_client=None):
        schema = [
            {'name': 'crypta_date', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'cids_last', 'type': 'int64'},
            {'name': 'cids_q', 'type': 'int64'},
            {'name': 'cids_intersection', 'type': 'int64'},
            {'name': 'cids_lost', 'type': 'double'},
            {'name': 'cids_gained', 'type': 'double'},
            {'name': 'additional', 'type': 'any'},
        ]
        super(CryptaStabilityCidsTable, self).__init__(
            table_path, schema, yt_client
        )

    def add_record(
            self, crypta_date, cids_last, cids_q, cids_intersection, cids_lost,
            cids_gained, additional=None):

        assert_date_str(crypta_date)
        additional = additional or {}

        record = {
            'crypta_date': crypta_date,
            'cids_last': cids_last,
            'cids_q': cids_q,
            'cids_intersection': cids_intersection,
            'cids_lost': cids_lost,
            'cids_gained': cids_gained,
            'additional': additional
        }
        self.insert_records([record])
