# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_config_table
from datacloud.dev_utils.logging.logger import get_basic_logger


logger = get_basic_logger(__name__)
DEFAULT_PATH = '//home/x-products/production/datacloud/stability/crypta_stability/config'
DEFAULT_MIN_HIT = 0.6


__all__ = [
    'CryptaStabilityConfigTable'
]


class CryptaStabilityConfigTable(yt_config_table.ConfigTable):
    def __init__(self, table_path=DEFAULT_PATH, yt_client=None):
        schema = [
            {'name': 'partner_id', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_name', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'min_hit', 'type': 'double'},
            {'name': 'additional', 'type': 'any'},
        ]
        super(CryptaStabilityConfigTable, self).__init__(
            table_path, schema, yt_client
        )

    def add_record(self, partner_id, score_name, min_hit=DEFAULT_MIN_HIT, additional=None):
        additional = additional or {}

        record = {
            'partner_id': partner_id,
            'score_name': score_name,
            'min_hit': min_hit,
            'additional': additional
        }
        self.insert_records([record])

    def get_record_by_score_name(self, score_name):
        return self.get_record_by_params({
            'score_name': score_name
        })
