# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_config_table
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.dev_utils.time.utils import assert_date_str


logger = get_basic_logger(__name__)
DEFAULT_PATH = '//home/x-products/production/datacloud/stability/crypta_stability/ids_log'


__all__ = [
    'CryptaStabilityIdValueTable'
]


class CryptaStabilityIdValueTable(yt_config_table.ConfigTable):
    def __init__(self, table_path=DEFAULT_PATH, yt_client=None):
        schema = [
            {'name': 'crypta_date', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'phone_id_values_mean', 'type': 'double'},
            {'name': 'phone_id_values_share', 'type': 'double'},
            {'name': 'email_id_values_mean', 'type': 'double'},
            {'name': 'email_id_values_share', 'type': 'double'},
            {'name': 'yuids_mean', 'type': 'double'},
            {'name': 'yuids_share', 'type': 'double'},
            {'name': 'additional', 'type': 'any'},
        ]
        super(CryptaStabilityIdValueTable, self).__init__(
            table_path, schema, yt_client
        )

    def add_record(
            self, crypta_date, phone_id_values_mean, phone_id_values_share,
            email_id_values_mean, email_id_values_share,
            yuids_mean, yuids_share, additional=None):

        assert_date_str(crypta_date)
        additional = additional or {}

        record = {
            'crypta_date': crypta_date,
            'phone_id_values_mean': phone_id_values_mean,
            'phone_id_values_share': phone_id_values_share,
            'email_id_values_mean': email_id_values_mean,
            'email_id_values_share': email_id_values_share,
            'yuids_mean': yuids_mean,
            'yuids_share': yuids_share,
            'additional': additional
        }
        self.insert_records([record])

    def add_record_by_dicts(self, crypta_date, type2mean, type2share, additional=None):
        self.add_record(
            crypta_date=crypta_date,
            phone_id_values_mean=type2mean['phone_id_value'],
            phone_id_values_share=type2share['phone_id_value'],
            email_id_values_mean=type2mean['email_id_value'],
            email_id_values_share=type2share['email_id_value'],
            yuids_mean=type2mean['yuid'],
            yuids_share=type2share['yuid'],
            additional=additional
        )
