# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_config_table
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.dev_utils.time.utils import assert_date_str


logger = get_basic_logger(__name__)
DEFAULT_PATH = '//home/x-products/production/datacloud/stability/scores_and_features_PSI/psi_features_all'


__all__ = [
    'FeaturesPSITable'
]


class FeaturesPSITable(yt_config_table.ConfigTable):
    def __init__(self, table_path=DEFAULT_PATH, yt_client=None):
        schema = [
            {'name': 'date', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'feature_name', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'PSI', 'type': 'any'},
            {'name': 'input_table', 'type': 'string'},
            {'name': 'reference_table', 'type': 'string'},
            {'name': 'is_reference', 'type': 'boolean'},
            {'name': 'table_size', 'type': 'int64'},
            {'name': 'additional', 'type': 'any'},
        ]
        super(FeaturesPSITable, self).__init__(
            table_path, schema, yt_client
        )

    def add_record(self, date, feature_name, PSI, input_table,
                   reference_table, is_reference, table_size, additional=None):

        assert_date_str(date)
        additional = additional or {}

        record = {
            'date': date,
            'feature_name': feature_name,
            'PSI': PSI,
            'input_table': input_table,
            'reference_table': reference_table,
            'is_reference': is_reference,
            'table_size': table_size,
            'additional': additional
        }
        self.insert_records([record])
