# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_config_table
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.dev_utils.time.utils import assert_date_str


logger = get_basic_logger(__name__)
DEFAULT_PATH = '//home/x-products/production/datacloud/stability/batch_monitoring/mini_batch_log'


__all__ = [
    'MiniBatchLogTable'
]


class MiniBatchLogTable(yt_config_table.ConfigTable):
    def __init__(self, table_path=DEFAULT_PATH, yt_client=None):
        schema = [
            {'name': 'partner_id', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_name', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_date', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'batch_name', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'AUC', 'type': 'double'},
            {'name': 'hit', 'type': 'double'},
            {'name': 'batch_size', 'type': 'uint64'},
            {'name': 'additional', 'type': 'any'}
        ]
        super(MiniBatchLogTable, self).__init__(
            table_path, schema, yt_client
        )

    def add_record(self, partner_id, score_name, score_date, batch_name, AUC, hit,
                   batch_size, additional=None):

        assert_date_str(score_date)
        additional = additional or {}

        record = {
            'partner_id': partner_id,
            'score_name': score_name,
            'score_date': score_date,
            'batch_name': batch_name,
            'AUC': AUC,
            'hit': hit,
            'batch_size': batch_size,
            'additional': additional
        }
        self.insert_records([record])
