# -*- coding: utf-8 -*-
from datacloud.dev_utils.solomon.solomon_utils import (
    post_sensors_to_solomon, get_schema, is_date, str2ts
)

SOLOMON_PROJECT = 'datacloud'
SOLOMON_CLUSTER = 'score'
MINI_BATCH_SERVICE = 'mini-batch-monitoring'
AUC_VALUE_TYPE = 'AUC'
HIT_VALUE_TYPE = 'hit'


def get_sensor(partner_id, score_name, score_date, batch_name, value_type, value):
    assert is_date(score_date), 'Given score_date does not look like date'

    return {
        'labels': {
            'partner_id': partner_id,
            'score_name': score_name,
            'batch_name': batch_name,
            'value_type': value_type
        },
        'ts': str2ts(score_date),
        'value': value
    }


def post_results(partner_id, score_name, score_date, batch_name, AUC, hit, **kwargs):
    sensors = [
        get_sensor(partner_id, score_name, score_date, batch_name, AUC_VALUE_TYPE, AUC),
        get_sensor(partner_id, score_name, score_date, batch_name, HIT_VALUE_TYPE, hit)
    ]
    post_sensors_to_solomon(SOLOMON_PROJECT, SOLOMON_CLUSTER, MINI_BATCH_SERVICE, sensors)
