# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_config_table
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.dev_utils.time.utils import assert_date_str


logger = get_basic_logger(__name__)
DEFAULT_PATH = '//home/x-products/production/datacloud/stability/score_acceptance_log'


__all__ = [
    'ScoreAcceptanceLogTable'
]


class ScoreAcceptanceLogTable(yt_config_table.ConfigTable):
    def __init__(self, table_path=DEFAULT_PATH, yt_client=None):
        schema = [
            {'name': 'partner_id', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_name', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'score_date', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'check_passed', 'type': 'boolean'},
            {'name': 'message', 'type': 'string'},
            {'name': 'additional', 'type': 'any'},
        ]
        super(ScoreAcceptanceLogTable, self).__init__(
            table_path, schema, yt_client
        )

    def add_record(self, partner_id, score_name, score_date, check_passed,
                   message, additional=None):
        assert_date_str(score_date)
        additional = additional or {}

        record = {
            'partner_id': partner_id,
            'score_name': score_name,
            'score_date': score_date,
            'check_passed': check_passed,
            'message': message,
            'additional': additional
        }
        self.insert_records([record])
