# -*- coding: utf-8 -*-
from datacloud.dev_utils.solomon.solomon_utils import (
    post_sensors_to_solomon, get_schema, is_date, str2ts
)

SOLOMON_PROJECT = 'datacloud'
SOLOMON_CLUSTER = 'stability'
SERVICE = 'score_acc_statuses'


def get_sensor(partner_id, score_name, score_date, check_passed, message):
    assert is_date(score_date), 'Given score_date does not look like date!'

    return {
        'labels': {
            'partner_id': partner_id,
            'score_name': score_name,
            'score_date': score_date,
            'message': message
        },
        'ts': str2ts(score_date),
        'value': int(check_passed)
    }


def post_results(partner_id, score_name, score_date, check_passed, message, **kwargs):
    sensors = [get_sensor(partner_id, score_name, score_date, check_passed, message)]
    post_sensors_to_solomon(SOLOMON_PROJECT, SOLOMON_CLUSTER, SERVICE, sensors)
