#!/usr/bin/env python
# coding: utf-8
from datetime import timedelta, datetime
import json
import pandas
from datetime import *
import time
import os
import zipfile
import io
from io import BytesIO
# from layer.yt.export.rep_corp.table import ExportRepCorp
import xlsxwriter
import requests
import psycopg2

import smtplib
import time
import imaplib
import email
import email.header
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication
from email.header import Header


def get_cursor(host, port, database, user='robot-corploader', key_file='keys.json', key_key='gp_token'):
    with open(key_file) as f:
        from_file = json.load(f)
    counter = 0
    while 1:
        try:
            gp_conn = psycopg2.connect(host=host,
                                       port=port,
                                       database=database,
                                       user=user,
                                       password=from_file[key_key],
                                       sslmode='require')
            break
        except psycopg2.OperationalError:
            print('s')
            pass
        counter += 1
        if counter > 10:
            template = {'from': 'b2b_mailer@yandex-team.ru', 'to': ['voytekh@yandex-team.ru'],
                        'cc': [], 'bcc': [],
                        'subject': 'ERROR - PSYCOPG RETRY LIMIT',
                        'body': 'fucking exceeded {}'}
            send_mail(template)
            exit()
    return gp_conn


def receivers(host, port, database, managers_table, url=None, ancestors=None, logins=None, flat=None,
              key_file='keys.json', key_key='gp_token',
              user='robot-corploader'):
    if not url and not ancestors and not logins and not flat:
        raise Exception("No receivers specified")
    if url and type(url) != list:
        raise Exception("Staff groups should be in lists")
    if ancestors and type(ancestors) != list:
        raise Exception("Staff groups should be in lists")
    if logins and type(logins) != list:
        raise Exception("Logins should be in lists")
    if flat and type(flat) != list:
        raise Exception("Logins flat should be in lists")
    conditions = []
    if url:
        conditions.append("m.url in ('{}')".format("', '".join(url)))
    if ancestors:
        conditions.append("ancestors::text SIMILAR TO '%({})%'".format("|".join(ancestors)))
    if logins:
        conditions.append("m.login in ('{}')".format("', '".join(logins)))
    if flat:
        conditions.append("m.login in ('{}')".format("', '".join(flat)))
    query = """
    SELECT m.login FROM {} as m 
    WHERE m.is_dismissed is false
    and (
        {}
    )
    order by m.login
    """.format(managers_table, ' or '.join(conditions))
    gp_conn = get_cursor(host, port, database, user=user, key_file=key_file, key_key=key_key)
    gp_cursor = gp_conn.cursor()
    gp_cursor.execute(query)
    receivers = gp_cursor.fetchall()
    gp_conn.close()
    receivers_cleared = set()
    for i in receivers:
        receivers_cleared.add(i[0])
    return receivers_cleared


def gp2df(host, port, database, query, key_file, key_key, user='robot-corploader'):
    gp_conn = get_cursor(host, port, database, user, key_file, key_key)
    df = pandas.read_sql_query(query, gp_conn)
    gp_conn.close()
    return df


def main2(receivers_url=None, receivers_ancestors=None, receivers_logins=None, mail_name='', mail_text='',
         mail_cc=None, hierarchy=True, emulate=False, key_file='keys.json', key_key='gp_token',
         flat=None, exclude_logins=None, user='robot-corploader', sheets=(),
        host='gpdb-master.taxi.yandex.net', port=5432, database='ritchie',
        managers_table='snb_b2b.voytekh_manager_v2'):
    template = {'from': 'Robot B2B <robot-corploader@yandex-team.ru>',
                'to': [],
                'cc': [],
                'bcc': [],
                'subject': mail_name,
                'body': mail_text}
    if mail_cc:
        template['cc'] = mail_cc

    for e in sheets:
        if e['query']:
            e['df'] = gp2df(host, port, database, e['query'], key_file, key_key, user)
            if 'deliveries_with_multi_cur' in e['df'].columns:
                e['df']['login'] = e['df'].apply(lambda x: 'malomanov' if x.contract_id == '894702/20' else x.login, axis=1) ## TODO
                print(e['df'][e['df']['contract_id'] == '894702/20'])

    receivers_ = receivers(host, port, database, managers_table, receivers_url, receivers_ancestors,
                           receivers_logins, flat, key_file, key_key, user)
    mailed_flat = False
    for r in receivers_:
        if exclude_logins and r in exclude_logins:
            continue
        if flat and r in flat and mailed_flat:
            continue
        elif flat and r in flat:
            mailed_flat = True
        io = BytesIO()

        writer = pandas.ExcelWriter(
            io,
            engine='xlsxwriter',
            date_format='dd.mm.yy',
            datetime_format='dd.mm.yy hh:mm:ss'
        )

        has_data = False
        for e in sheets:
            if not flat or r not in flat:
                if hierarchy:
                    print(e['df'])
                    mask = e['df'].apply(lambda x: r in (x.hierarchy if x.hierarchy else ()), axis=1) ## TODO and this bad kostyl
                    df2 = e['df'][mask]
                else:
                    df2=e['df'][e['df'].login == r]
            else:
                df2 = e['df']
            if 'login' in df2:
                df2 = df2.drop(columns=['login'])
            if 'hierarchy' in df2:
                df2 = df2.drop(columns=['hierarchy'])

            if e['exclude_columns'] is not None:
                for k in e['exclude_columns']:
                    if k in df2:
                        df2 = df2.drop(columns=[k])

            df2 = df2.rename(
                index=str,
                columns=e['col_names']
            )

            if e.get('style', None):
                df2 = df2.style.apply(**e['style'])

            df2.to_excel(writer, index=False, sheet_name=e['sheet_name'])
            if (e.get('style', None) and not df2.data.empty) or (e.get('style', None) is None and not df2.empty):
                has_data = True
        writer.save()

        if has_data:
            if not emulate:
                if flat and r in flat:
                    template['to'] = ['{}@yandex-team.ru'.format(t) for t in flat]
                else:
                    template['to'] = ['{}@yandex-team.ru'.format(r) ]
            if flat and r in flat:
                template['subject'] = mail_name + ' flat'
            else:
                template['subject'] = mail_name + ' ' + str(r)
            template['attach'] = io
            send_mail(template)
    time.sleep(10)


def send_mail(template, file_name=f'report {datetime.now()}.xlsx', coding='plain'):
    russian = 'windows-1251'

    msg = MIMEMultipart()
    msg["Subject"] = email.header.Header(template['subject'], russian)
    msg["From"] = template['from']
    msg["To"] = ",".join(template['to'])
    msg["Cc"] = ",".join(template['cc'])

    m = template['body']
    if coding == 'plain':
        text = MIMEText(m.encode('utf-8'), 'plain', 'utf-8')
    else:
        text = MIMEText(m, 'html', 'UTF-8')
    text['Subject'] = Header(m, 'utf-8')
    msg.attach(text)

    if 'attach' in template:
        if type(template['attach']) == dict:
            for k, v in template['attach'].items():
                part = MIMEApplication(
                    v.getvalue(),
                    Name=k
                )
                # After the file is closed
                part['Content-Disposition'] = 'attachment; filename="%s"' % k
                msg.attach(part)
        else:
            part = MIMEApplication(
                template['attach'].getvalue(),
                Name=file_name
            )
            # After the file is closed
            part['Content-Disposition'] = 'attachment; filename="%s"' % file_name
            msg.attach(part)

    server = smtplib.SMTP('outbound-relay.yandex.net', 25)
    # server.connect('yabacks.yandex.ru', 25) py3 only
    server.ehlo()
    receivers = set(template['to'] + template['cc'] + template['bcc'])
    server.sendmail(template['from'], receivers, msg.as_string())
    server.close()

import pandas as pd
from business_models import greenplum
from business_models.greenplum import GreenplumManager
import json
key_file = 'keys.json'
gp_user = 'robot-sam-bridges'
# key_key='sam_gp_token'
key_key='gp_token'
with open(key_file, 'r') as f:
    keys = json.load(f)
gp_token = keys[key_key]
greenplum = GreenplumManager(user=gp_user, token = gp_token)

# from b2b_mailer import main2

import datetime
from datetime import datetime as dt
import logging

import sys
logging.basicConfig(stream=sys.stdout, level=logging.INFO,
                    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s')
logging.info('Start')

with open ('logdata_1834_sdd_funnel.sql') as f:
    sql = f.read()
greenplum(sql)
logging.info('Datamart comleted')

query_main = """
select * from snb_b2b.niksm_dash_sdd_funnel_1834
order by which_crm, deal_id
"""
df_main = greenplum(query_main)

query_wishlist = """
--Анализ сделок по виш-листу
with sdd_pipeline_stage_srt(field_srt, stage_name) as (
  values (-3, 'Проиграно'),
           (-2, '(old) Отложить'),
           (-1, '(old) Отток'),
           (1, '1. Идея'),
           (2, '2. Провести встречу'),
           (3, '3. Переговоры'),
           (4, '4. Заключение договора'),
           (5, '5. Старт'),
           (6, '6. Разгон'),
           (7, '7. Развитие'),
           (8, '8. Удержание')
)
select wishlist,
       sdd_pipeline_stage_srt,
       sdd_pipeline_stage,
       count() as deals_cnt,
       sum(potential) as potential
from (
    select which_crm,
           deal_id,
           srt.field_srt as sdd_pipeline_stage_srt,
           sdd_pipeline_stage,
           potential,
           json_array_elements_text(wishlist::json) as wishlist
    from snb_b2b.niksm_b2b_deals_info_amo crm
      join sdd_pipeline_stage_srt srt
        on srt.stage_name = crm.sdd_pipeline_stage
    where true
      and which_crm = 6
) q
where true
  and position('SDD:' in wishlist)>0
group by 1,2,3;
"""
df_wishlist = greenplum(query_wishlist)
df_record_date = greenplum('select max(record_date) as record_date from snb_b2b.niksm_dash_sdd_funnel_1834')
record_date_str = df_record_date['record_date'][0].strftime('%Y-%m-%d')

logging.info(f'Dataframe size: df_main = {len(df_main)}, df_wishlist = {len(df_wishlist)}, record_date = {record_date_str}')

main2(
    receivers_url=None,
    # add to receivers all people from specific groups at staff
    receivers_ancestors=None,
    # add to receivers people, who have listed groups above theirs
    receivers_logins=None,  # add to receivers people by logins
    exclude_logins=None,
    mail_name='Отчёт для воронки SDD',  # name of letter
    mail_text='Данные для воронки SDD за ' + record_date_str,  # body of letter
    mail_cc=[],  # send a copy to listed emails
    hierarchy=True,
    # True: send to a receiver if they are present in hierarchy field, False: send to a receiver if they are in login field of query
    emulate=False,  # Do not send to receiver (will still send to adresses in mail_cc field)
    key_file=key_file,  # where the keys are
    key_key=key_key,  # key of gp token in file
    flat=['niksm','ferenec','alextitov','anashche','zudilin'],  #       list of emails. mail all rows to these addresses
    user=gp_user,
    database='ritchie',
    host='gpdb-master.taxi.yandex.net',
    port=5432,
    managers_table='snb_b2b.voytekh_manager_v2',
    sheets=[
        {'query': None,
         'df': df_main,
         'exclude_columns': None,
         'col_names': None,
         'sheet_name': 'data_main'},
        {'query': None,
         'df': df_wishlist,
         'exclude_columns': None,
         'col_names': None,
         'sheet_name': 'data_wishlist'}
    ]
)

logging.info('SUCCESS')
