drop table if exists alextitov_1834_sdd_funnel_sdd_hist;
create temporary table alextitov_1834_sdd_funnel_sdd_hist as
select msk_snapshot_dt as record_date,
       6 as which_crm,
       lead_id::int as deal_id,
       --
       null as  sdd_pipeline_stage_key,
       sdd_pipeline_stage,
       null sdd_integration_status_key,
       sdd_integration_status
from snb_b2b.amo_leads_info_hist dlh
where msk_snapshot_dt >= '2021-01-01'
  and sdd_pipeline_stage is not null;

analyse alextitov_1834_sdd_funnel_sdd_hist;
----------------------------------------------------------

drop table if exists alextitov_temp_1834_sdd_funnel_res;
create temporary table alextitov_temp_1834_sdd_funnel_res as
with sdd_pipeline_stage_srt(field_srt, stage_name) as (
  values (-3, 'Проиграно'),
           (-2, '(old) Отложить'),
           (-1, '(old) Отток'),
           (1, '1. Идея'),
           (2, '2. Провести встречу'),
           (3, '3. Переговоры'),
           (4, '4. Заключение договора'),
           (5, '5. Старт'),
           (6, '6. Разгон'),
           (7, '7. Развитие'),
           (8, '8. Удержание')
)
, sdd_integration_status_srt(field_srt, integration_name) as (
    values (1, '1. Направлена информация по интеграции'), -- Направлена информация по интеграции
           (2, '2. Получено решение о запуске интеграции'), -- Получено решение о запуске интеграции
           (3, '3. Подготовка к запуску интеграции'), -- Подготовка к запуску интеграции
           (4, '4. Идет интеграция'), -- Идет интеграция
           (5, '5. Интеграция завершена') -- Интеграция завершена
)
, calend as (
    select calday, calday_prev
    from (
        select clnd.calday as calday,
               wd.calday as calday_prev,
               row_number() over (partition by clnd.calday order by wd.calday desc) as rn
        from snb_delivery.logdata_calendar clnd
          cross join snb_delivery.logdata_calendar wd
        where wd.working_day_flg
          and wd.calday < clnd.calday
    ) q
    where rn = 5
)
, raw as (
    select crm.which_crm,
           crm.deal_id,
           max(deal_title) as deal_title,
           max(manager_group) as manager_group,
           max(manager_login) as manager_login,
           max(manager_name) as manager_name,
           max(crm.contract_id) as contract_id,
           max(crm.add_date) as deal_add_date,
           max(crm.channel) as channel,
           max(market_segment) as market_segment,
           max(crm.wishlist) as wishlist,
           max(crm.product) as product,
           max(crm.city) as city,
           max(crm.geography) as geography,
           max(srt_stage_crm.field_srt) as sdd_pipeline_stage_srt,
           max(crm.sdd_pipeline_stage) as sdd_pipeline_stage,
           max(srt_intgr_crm.field_srt) as sdd_integration_status_srt,
           max(crm.sdd_integration_status) as sdd_integration_status,
           max(crm.sdd_potential) as sdd_potential,
           min(case when hist.sdd_pipeline_stage is not null and srt_stage_hist.field_srt <> 1 then hist.record_date end) as sdd_add_date,
           ----
           min(case when srt_stage_hist.field_srt = 1 then hist.record_date end) as pipeline_stage_first_dt_stage_1,
           min(case when srt_stage_hist.field_srt = 2 then hist.record_date end) as pipeline_stage_first_dt_stage_2,
           min(case when srt_stage_hist.field_srt = 3 then hist.record_date end) as pipeline_stage_first_dt_stage_3,
           min(case when srt_stage_hist.field_srt = 4 then hist.record_date end) as pipeline_stage_first_dt_stage_4,
           min(case when srt_stage_hist.field_srt = 5 then hist.record_date end) as pipeline_stage_first_dt_stage_5,
           min(case when srt_stage_hist.field_srt = 6 then hist.record_date end) as pipeline_stage_first_dt_stage_6,
           min(case when srt_stage_hist.field_srt = 7 then hist.record_date end) as pipeline_stage_first_dt_stage_7,
           min(case when srt_stage_hist.field_srt = 8 then hist.record_date end) as pipeline_stage_first_dt_stage_8,
           sum(case when crm.sdd_pipeline_stage = hist.sdd_pipeline_stage then 1 else 0 end) as days_in_last_pipeline_stage,
           --
           max(case when hist.record_date = crm.record_date -  1 then srt_stage_hist.field_srt end) as prev_pipeline_stage_srt_1d,
           max(case when hist.record_date = crm.record_date -  7 then srt_stage_hist.field_srt end) as prev_pipeline_stage_srt_1w,
           max(case when hist.record_date = crm.record_date - 30 then srt_stage_hist.field_srt end) as prev_pipeline_stage_srt_1m,
           ----
           min(case when srt_intgr_hist.field_srt = 1 then hist.record_date end) as integration_status_first_dt_stage_1,
           min(case when srt_intgr_hist.field_srt = 2 then hist.record_date end) as integration_status_first_dt_stage_2,
           min(case when srt_intgr_hist.field_srt = 3 then hist.record_date end) as integration_status_first_dt_stage_3,
           min(case when srt_intgr_hist.field_srt = 4 then hist.record_date end) as integration_status_first_dt_stage_4,
           min(case when srt_intgr_hist.field_srt = 5 then hist.record_date end) as integration_status_first_dt_stage_5,
           sum(case when crm.sdd_integration_status = hist.sdd_integration_status then 1 else 0 end) as days_in_last_integration_status,
           --
           max(case when hist.record_date = crm.record_date -  1 then srt_intgr_hist.field_srt end) as prev_integration_status_srt_1d,
           max(case when hist.record_date = crm.record_date -  7 then srt_intgr_hist.field_srt end) as prev_integration_status_srt_1w,
           max(case when hist.record_date = crm.record_date - 30 then srt_intgr_hist.field_srt end) as prev_integration_status_srt_1m,
           --
           max(crm.record_date) as record_date
    from snb_b2b.niksm_b2b_deals_info_amo crm
      join sdd_pipeline_stage_srt srt_stage_crm
        on srt_stage_crm.stage_name = crm.sdd_pipeline_stage
      left join sdd_integration_status_srt srt_intgr_crm
        on srt_intgr_crm.integration_name = crm.sdd_integration_status
      left join alextitov_1834_sdd_funnel_sdd_hist hist
        on crm.which_crm = hist.which_crm
        and crm.deal_id = hist.deal_id
      left join sdd_pipeline_stage_srt srt_stage_hist
        on srt_stage_hist.stage_name = hist.sdd_pipeline_stage
      left join sdd_integration_status_srt srt_intgr_hist
        on srt_intgr_hist.integration_name = hist.sdd_integration_status
    where crm.which_crm = 6
    group by crm.which_crm, crm.deal_id
)
, contract_dlv as (
    select corp_client_id,
           min(substr(created_dttm,1,10)::date) as first_delivery_dt,
           count(distinct case when substr(created_dttm,1,10)::date
               between current_date-7 and current_date-1
               then request_id end) as orders_cnt_7d,
           count(distinct case when substr(created_dttm,1,10)::date
               between date_trunc('week',current_date)::date-7 and date_trunc('week',current_date)::date-1
               then request_id end) as orders_cnt_lw,
           count(distinct case when substr(created_dttm,1,10)::date
               between current_date-30 and current_date-1
               then request_id end) as orders_cnt_30d
    from snb_delivery.logdata_ndd_requests_datamart sdd
    where corp_client_id is not null
      and mapped_event_type in ('Доставлен', 'Доставлен частично')
    group by corp_client_id
)
select which_crm, deal_id,
       deal_title,
       manager_group,
       coalesce(manager_name, manager_login) as manager_name,
       deal_add_date,
       case when deal_add_date <= calday_prev or calday_prev is null then 'Кросс-сейл' else channel end as channel,
       coalesce(market_segment, 'N/A') as market_segment,
       wishlist, product,
       coalesce(city, 'N/A') as city,
       geography,
       sdd_pipeline_stage_srt, sdd_pipeline_stage,
       sdd_integration_status_srt, sdd_integration_status,
       sdd_potential,
       sdd_add_date,
       pipeline_stage_first_dt_stage_1, pipeline_stage_first_dt_stage_2, pipeline_stage_first_dt_stage_3,
       pipeline_stage_first_dt_stage_4, pipeline_stage_first_dt_stage_5, pipeline_stage_first_dt_stage_6,
       pipeline_stage_first_dt_stage_7,pipeline_stage_first_dt_stage_8,
       days_in_last_pipeline_stage,
       prev_pipeline_stage_srt_1d, prev_pipeline_stage_srt_1w, prev_pipeline_stage_srt_1m,
       --
       integration_status_first_dt_stage_1, integration_status_first_dt_stage_2, integration_status_first_dt_stage_3,
       integration_status_first_dt_stage_4, integration_status_first_dt_stage_5,
       days_in_last_integration_status,
       prev_integration_status_srt_1d, prev_integration_status_srt_1w, prev_integration_status_srt_1m,
       contract_dlv.corp_client_id is not null as sdd_delivery_flg,
       first_delivery_dt,
       orders_cnt_7d, orders_cnt_lw, orders_cnt_30d,
       case when contract_dlv.corp_client_id is not null then greatest(0, first_delivery_dt - sdd_add_date) else 0 end as sdd_dlv_cycle_days,
       blnc.contract_external_id is not null as balance_contract_flg,
       lk_cargo_next_day_delivery::boolean as lk_cargo_sdd_flg,
       record_date
from raw
  left join calend
    on calend.calday = raw.sdd_add_date
  left join snb_b2b.niksm_b2b_lk_contract_info lk
    on lk.contract_external_id = raw.contract_id
  left join contract_dlv
    on contract_dlv.corp_client_id = lk.lk_client_id
  left join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = raw.contract_id;
--
analyse alextitov_temp_1834_sdd_funnel_res;

--====================================================================================================================--

-- drop table if exists snb_b2b.niksm_dash_sdd_funnel_1834;
-- create table snb_b2b.niksm_dash_sdd_funnel_1834 as
truncate table snb_b2b.niksm_dash_sdd_funnel_1834;
insert into snb_b2b.niksm_dash_sdd_funnel_1834
    (which_crm, deal_id,
       deal_title, manager_group, manager_name, deal_add_date, channel, market_segment, wishlist, product, city, geography,
       sdd_pipeline_stage_srt, sdd_pipeline_stage, sdd_integration_status_srt, sdd_integration_status, sdd_potential, sdd_add_date,
       pipeline_stage_first_dt_stage_1, pipeline_stage_first_dt_stage_2, pipeline_stage_first_dt_stage_3,
       pipeline_stage_first_dt_stage_4, pipeline_stage_first_dt_stage_5, pipeline_stage_first_dt_stage_6,
       pipeline_stage_first_dt_stage_7,pipeline_stage_first_dt_stage_8,
       days_in_last_pipeline_stage,
       prev_pipeline_stage_srt_1d, prev_pipeline_stage_srt_1w, prev_pipeline_stage_srt_1m,
       integration_status_first_dt_stage_1, integration_status_first_dt_stage_2, integration_status_first_dt_stage_3,
       integration_status_first_dt_stage_4, integration_status_first_dt_stage_5,
       days_in_last_integration_status,
       prev_integration_status_srt_1d, prev_integration_status_srt_1w, prev_integration_status_srt_1m,
       sdd_delivery_flg, first_delivery_dt, orders_cnt_7d, orders_cnt_lw, orders_cnt_30d, sdd_dlv_cycle_days,
       balance_contract_flg, lk_cargo_sdd_flg,
       record_date)
select which_crm, deal_id,
       deal_title, manager_group, manager_name, deal_add_date, channel, market_segment, wishlist, product, city, geography,
       sdd_pipeline_stage_srt, sdd_pipeline_stage, sdd_integration_status_srt, sdd_integration_status, sdd_potential, sdd_add_date,
       pipeline_stage_first_dt_stage_1, pipeline_stage_first_dt_stage_2, pipeline_stage_first_dt_stage_3,
       pipeline_stage_first_dt_stage_4, pipeline_stage_first_dt_stage_5, pipeline_stage_first_dt_stage_6,
       pipeline_stage_first_dt_stage_7,pipeline_stage_first_dt_stage_8,
       days_in_last_pipeline_stage,
       prev_pipeline_stage_srt_1d, prev_pipeline_stage_srt_1w, prev_pipeline_stage_srt_1m,
       integration_status_first_dt_stage_1, integration_status_first_dt_stage_2, integration_status_first_dt_stage_3,
       integration_status_first_dt_stage_4, integration_status_first_dt_stage_5,
       days_in_last_integration_status,
       prev_integration_status_srt_1d, prev_integration_status_srt_1w, prev_integration_status_srt_1m,
       sdd_delivery_flg, first_delivery_dt, orders_cnt_7d, orders_cnt_lw, orders_cnt_30d, sdd_dlv_cycle_days,
       balance_contract_flg, lk_cargo_sdd_flg,
       record_date
from alextitov_temp_1834_sdd_funnel_res;


------------------------------------
-------------------------------------

