USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$DT_FORMAT = DateTime::Format("%Y-%m-%d");
$parse_dttm = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$dttm = DateTime::MakeDatetime;

$INSERT_PATH = '//home/taxi-delivery/analytics/production/product/exp_same_day_israel/same_day_israel_orders_nrvn';
$dim_currency_rate = "//home/taxi-dwh/cdm/money/dim_currency_rate";

$dim_currency_rate  = (
    SELECT `date` as date_r,
       rate,
       source_cur
    from $dim_currency_rate
    where target_cur == "RUB" --and source_cur ='ILS'
    group by `date`,
        rate,
        source_cur
);

$sdd = (
    SELECT
        *
    FROM range(`//home/taxi-delivery/analytics/production/ld/aliase_groups`, `2022-01-25`)
    where alias = 'same-day-israel' or alias = 'same-day-chile'
);

$geo = (
    select tariff_zone,
        node_id as agglomeration_node_id,
        name_ru as city_name_ru
    from `//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy`
    where node_type = 'agglomeration'
        and root_node_id = 'br_root'
);

$all_info_orders = (
select
    claim.utc_created_dttm as claim_utc_created_dttm,
    $DT_FORMAT($dttm($parse_dttm(claim.utc_created_dttm))) as utc_order_created_dt,
    claim.api_source_type as api_source_type,
    true as corp_order_flg,
    claim.claim_id as claim_id,
    claim.cargo_ref_id as cargo_ref_id,
    claim.corp_client_id as corp_client_id,
    claim.currency_code as currency_code,
    claim.delayed_dispatch_flg as delayed_dispatch_flg,
    claim.delayed_flg as delayed_flg,
    claim.status_code as status_code,
    geo.agglomeration_node_id as agglomeration_node_id,
    geo.city_name_ru as city_name_ru,
    claim.taxi_order_id as taxi_order_id,
    sdd.alias as alias,
    waybill.router_code as router_code,
    waybill.utc_created_dttm as waybill_utc_created_dttm,
    fct_delivery.utc_claim_due_dttm as utc_claim_due_dttm,
    fct_delivery.utc_claim_created_dttm as utc_claim_accepted_dttm,
    fct_delivery.utc_claim_start_performer_lookup_dttm as utc_claim_performer_draft_dttm,
    fct_delivery.utc_claim_performer_found_dttm as utc_claim_performer_found_dttm,
    fct_delivery.taxi_order_lcy_cost as order_cost,
    fct_delivery.taxi_success_order_flg as success_order_flg,
    fct_delivery.taxi_app_name as app_name,
    fct_delivery.taxi_app_platform_name as app_platform_name,
    fct_delivery.taxi_tariff_class_code as tariff_class_code,
    fct_delivery.taxi_fake_order_flg as fake_order_flg,
    fct_delivery.taxi_user_fraud_flg as user_fraud_flg,
    fct_delivery.taxi_mqc_order_flg as mqc_order_flg,
    fct_delivery.taxi_user_client_id as user_id,
    fct_order_metric.net_inflow_amt as net_inflow_amt

from $sdd  as sdd
LEFT JOIN range(`//home/delivery-dwh/ods/cargo_claims/claim_segment`, `2022-01-01`) as claim_segment
        on claim_segment.claim_segment_uuid = sdd.segment_id
left join range(`//home/delivery-dwh/ods/cargo_claims/claim`, `2022-01-01`) as claim
    on claim_segment.claim_id = claim.claim_id
left join range(`//home/delivery-dwh/ods/cargo_dispatch/dispatch_segment`, `2022-01-01`) as dispatch_segment
    on claim.cargo_ref_id = dispatch_segment.claim_uuid
left join range(`//home/delivery-dwh/ods/cargo_dispatch/waybill`, `2022-01-01`) as waybill
    on dispatch_segment.waybill_uuid = waybill.waybill_uuid
left join range(`//home/delivery-dwh/cdm/delivery/fct_delivery`, `2022-01-01`) as fct_delivery
    on claim_segment.claim_id = fct_delivery.claim_id
left join $geo as geo
    on geo.tariff_zone = claim.tariff_zone
left join range(`//home/taxi-dwh/cdm/marketplace/fct_order_metric`, `2022-01-01`) as fct_order_metric
    on fct_order_metric.order_id = claim.taxi_order_id
);

$fct_d = (
select order_id, count(distinct claim_id) as cnt_claim
from range(`//home/delivery-dwh/cdm/delivery/fct_delivery`, `2022-01-01`) as fct_delivery
where order_id in (select distinct taxi_order_id from $all_info_orders)
group by order_id
);

insert into $INSERT_PATH with truncate
select ord.*,
    case when currency_code <> 'RUB' then ord.order_cost * c_rate.rate
        else ord.order_cost end as gross_bookings,
    case when currency_code <> 'RUB' then ord.net_inflow_amt * c_rate.rate
        else ord.net_inflow_amt end as net_inflow_rub,
    fct_d.cnt_claim as cnt_claim
from $all_info_orders as ord
left join $dim_currency_rate as c_rate
    on c_rate.date_r = ord.utc_order_created_dt
        and ord.currency_code = c_rate.source_cur
left join $fct_d as fct_d
    on ord.taxi_order_id = fct_d.order_id
;
