--truncate table snb_delivery.ferenec_contract_funnel;
create table snb_delivery.ferenec_contract_funnel as
--insert into snb_delivery.ferenec_contract_funnel
with raw0 as (
    select fct.corp_client_id                                                                   as corp_client_id,
           corp_contract_id,
           min(min(msk_order_created_dt)) over (partition by corp_client_id,fct.corp_client_id) as first_delivery_dt
    from taxi_cdm_marketplace.fct_order as fct
    where true
      and fct.utc_order_created_dttm >= '2022-01-01' -- for partitioning
      and fct.success_order_flg
      and not fct.mqc_order_flg
    group by 1, 2
    having sum(delivery_point_cnt) > 0
)

   , cw as (
    select cw.key                                                        as cw_ticket_key
         , cw.type
         , cw.status
         , cw.resolution
         , cw.resolution in ('fixed', 'targetLead') and cw.type = 'task' as fixed_flg
         , (to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
            'Europe/Moscow')::timestamp                                  as cw_date_tiket_open
         , (to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
            'Europe/Moscow')::date                                       as created_CW
         , cw.deal
         , SUBSTRING(cw.deal, 'Y*([0-9]{1,100})') ::integer              as deal_id
         , utmsource
    from snb_b2b.voytekh_corpwelcome cw
    where (to_timestamp(EXTRACT(EPOCH FROM created::timestamp)) at time zone 'Europe/Moscow')::date >= '2022-05-25'
)
   , dh as (
    select dih.deal_id,
           dih.which_crm,
           min(dih.snapshot_date)                               snapshot_date,
           (dih.status = 'open' and dih_old.status = 'lost') as restart_deal
    from snb_b2b.niksm_b2b_deals_info_hist dih
             left join snb_b2b.niksm_b2b_deals_info_hist dih_old
                       on dih.deal_id = dih_old.deal_id
                           and dih.which_crm = dih_old.which_crm
                           and dih.snapshot_date = dih_old.snapshot_date + 1
    where dih.status = 'open'
      and dih_old.status = 'lost'
    group by dih.deal_id, dih.which_crm, (dih.status = 'open' and dih_old.status = 'lost')
)
   , t_deal as (
    select di.deal_id,
           di.status = 'lost'                                                                                      as status_lost,
           di.status,
           di.lost_reason,
           di.contract_id,
           di.contract_type = 'Оферта'                                                                             as contract_offerta_flg,
           di.manager_group,
           di.manager_login,
           di.manager_name,
           di.country,
           di.channel,
           di.tags,
           di.potential,
           di.corp_client_id,
           to_timestamp(EXTRACT(EPOCH FROM coalesce(dh.snapshot_date::timestamp, di.add_time))) at time zone
           'UTC'                                                                                                   as open_deal_time,
           coalesce(snapshot_date, di.add_date)                                                                    as open_deal_date,
           di.pipeline_id = 5208781                                                                                as phinics_flg,
           coalesce(dh.restart_deal, false)                                                                        as restart_deal
    from snb_b2b.niksm_b2b_deals_info di
             left join dh
                       on dh.deal_id = di.deal_id and dh.which_crm = di.which_crm
    where di.which_crm = 6
)

select   cw_ticket_key,fixed_flg,created_cw, t_deal.deal_id,open_deal_date, utmsource,country, restart_deal, t_deal.status,contract_id,
         coalesce(t_deal.corp_client_id,lk.lk_client_id) as corp_client_id,
         case when first_delivery_dt is not null then coalesce(t_deal.corp_client_id,lk.lk_client_id) end as first_delivery,
         first_delivery_dt
from t_deal
join cw on t_deal.deal_id = cw.deal_id
left join snb_b2b.niksm_b2b_lk_contract_info lk on lk.contract_external_id=t_deal.contract_id
left join raw0 on raw0.corp_client_id = coalesce(t_deal.corp_client_id,lk.lk_client_id) and raw0.corp_contract_id=t_deal.contract_id
where channel='САМООБРАЩЕНИЕ';

--drop table snb_delivery.ferenec_contract_funnel;