-- BY Holding
with dlv as (
    select corp_contract_id,
           sum(delivery_point_cnt) as deliveries_cnt
    from taxi_cdm_marketplace.fct_order
    where true
      and corp_order_flg
      and corp_contract_id is not null
      and utc_order_created_dttm >= current_date-31
      and msk_order_created_dt between current_date-30 and current_date-1
    group by 1
)
, raw as (
    select coalesce(crm.holding_name, crm.company_name, lead_name) as client_name,
           --
           contract_external_id,
           start_dt,
           blnc.is_active,
           crm.add_contract_flg,
           coalesce(deliveries_cnt,0) as deliveries_cnt,
           crm.price as potential,
           crm.lead_id,
           position('"Старая Яндекс Доставка"' in crm.product)>0 as old_yado_flg,
           --
           first_value(manager_metagroup) over (partition by coalesce(crm.holding_name, crm.company_name, lead_name)
               order by deliveries_cnt desc, crm.add_contract_flg desc) as manager_metagroup,
           first_value(manager_group) over (partition by coalesce(crm.holding_name, crm.company_name, lead_name)
               order by deliveries_cnt desc, crm.add_contract_flg desc) as manager_group,
           first_value(teamlead_name) over (partition by coalesce(crm.holding_name, crm.company_name, lead_name)
               order by deliveries_cnt desc, crm.add_contract_flg desc) as teamlead_name,
           first_value(manager_name) over (partition by coalesce(crm.holding_name, crm.company_name, lead_name)
               order by deliveries_cnt desc, crm.add_contract_flg desc) as manager_name,
           first_value(blnc.person_name) over (partition by coalesce(crm.holding_name, crm.company_name, lead_name)
               order by deliveries_cnt desc, crm.add_contract_flg desc) as balance_org_name,
           first_value(lead_id) over (partition by coalesce(crm.holding_name, crm.company_name, lead_name)
               order by deliveries_cnt desc, crm.add_contract_flg desc) as lead_id_top
    from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
      join snb_b2b.amo_contracts_info crm
        on crm.contract_id = blnc.contract_external_id
      left join dlv
        on dlv.corp_contract_id = blnc.contract_external_id
    where crm.crm_source = 'yandexdelivery'
      and crm.manager_metagroup in ('Тир 1','Тир 2')
)
select client_name,
       max(manager_metagroup) as manager_metagroup,
       max(manager_group) as manager_group,
       max(teamlead_name) as teamlead_name,
       max(manager_name) as manager_name,
       max(balance_org_name) as "Имя из Баланса",
       max(lead_id_top) as "Сделка с максимальными доставками",
       'https://yandexdelivery.amocrm.ru/leads/detail/' || max(lead_id_top) as "Ссылка на сделку с максимальными доставками",
       string_agg(lead_id::text, ', ') as "Список сделок",
       bool_and(old_yado_flg) as "Все сделки содержат продукт Старая Яндекс Доставка",
       min(start_dt)>=current_date-30 as newbie_flg,
       --
       sum(is_active) as contracts_cnt,
       sum(case when is_active=1 and add_contract_flg then 1 else 0 end) as add_contracts_cnt,
       sum(deliveries_cnt) as deliveries_cnt,
       sum(potential) as potential
from raw
group by 1
having max(is_active) = 1
order by deliveries_cnt desc;


------------------------------------------------------------------------------------------------------------------------
-- BY INN-KPP
with dlv as (
    select corp_contract_id,
           sum(n_deliveries_visited) as deliveries_cnt
    from snb_taxi.logdata_fct_order
    where logistic_tariff_flag
      and success_order_flg
      and corp_order_flg
      and utc_order_created_dttm >= current_date-31
      and msk_order_created_dt between current_date-30 and current_date-1
    group by 1
)
, raw as (
    select person_inn, person_kpp,
           --
           contract_external_id,
           start_dt,
           blnc.is_active,
           coalesce(pipeline_name = 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',False) as add_contract_flg,
           coalesce(deliveries_cnt,0) as deliveries_cnt,
           crm.potential,
           --
           first_value(manager_group) over (partition by person_inn, person_kpp
               order by deliveries_cnt desc, coalesce(pipeline_name = 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',False) desc) as manager_group,
           first_value(case when lead_name = 'Суворов Александр' then manager_name else lead_name end) over (partition by person_inn, person_kpp
               order by deliveries_cnt desc, coalesce(pipeline_name = 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',False) desc) as lead_name,
           first_value(manager_name) over (partition by person_inn, person_kpp
               order by deliveries_cnt desc, coalesce(pipeline_name = 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',False) desc) as manager_name,
           first_value(blnc.person_name) over (partition by person_inn, person_kpp
               order by deliveries_cnt desc, coalesce(pipeline_name = 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',False) desc) as balance_org_name
    from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
      join snb_b2b.niksm_b2b_contracts_info crm
        on crm.contract_id = blnc.contract_external_id
      left join dlv
        on dlv.corp_contract_id = blnc.contract_external_id
    where which_crm = 6
      and crm.manager_group in ('ГПП 1','ГМП 1','ГМП 2','ГМП 3','ГМП 4')
)
select person_inn, person_kpp,
       max(manager_group) as manager_group,
       max(lead_name) as lead_name,
       max(manager_name) as manager_name,
       max(balance_org_name) as balance_org_name,
       min(start_dt)>=current_date-30 as newbie_flg,
       --
       sum(is_active) as contracts_cnt,
       sum(case when is_active=1 and add_contract_flg then 1 else 0 end) as add_contracts_cnt,
       sum(deliveries_cnt) as deliveries_cnt,
       sum(potential) as potential
from raw
-- where manager_group in ('ГПП 1','ГПП 2','ГМП 1','ГМП 2','ГМП NDD')
group by 1,2
having max(is_active) = 1
order by deliveries_cnt desc;


-- check
with dlv as (
    select corp_contract_id,
           sum(n_deliveries_visited) as deliveries_cnt
    from snb_taxi.logdata_fct_order
    where logistic_tariff_flag
      and success_order_flg
      and corp_order_flg
      and utc_order_created_dttm >= current_date-31
      and msk_order_created_dt between current_date-30 and current_date-1
    group by 1
)
, raw as (
    select crm.client_id, crm.client_name,
           person_inn, person_kpp,
           --
           contract_external_id,
           start_dt,
           blnc.is_active,
           coalesce(pipeline_name = 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',False) as add_contract_flg,
           coalesce(deliveries_cnt,0) as deliveries_cnt,
           --
           first_value(manager_group) over (partition by crm.client_id, crm.client_name
               order by deliveries_cnt desc, coalesce(pipeline_name = 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',False) desc) as manager_group_holding,
           first_value(manager_group) over (partition by person_inn, person_kpp
               order by deliveries_cnt desc, coalesce(pipeline_name = 'ДОПОЛНИТЕЛЬНЫЕ ДОГОВОРЫ',False) desc) as manager_group_inn,
           max(is_active) over (partition by crm.client_id, crm.client_name) as max_is_active_holding,
           max(is_active) over (partition by person_inn, person_kpp) as max_is_active_inn
    from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
      join snb_b2b.niksm_b2b_contracts_info crm
        on crm.contract_id = blnc.contract_external_id
      left join dlv
        on dlv.corp_contract_id = blnc.contract_external_id
    where which_crm = 6
      and crm.manager_group in ('ГПП 1','ГМП 1','ГМП 2','ГМП 3','ГМП 4')
)
select *
from raw
where true
--   and manager_group_holding in ('ГПП 1','ГМП 1','ГМП 2','ГМП 3','ГМП 4')
--   and not manager_group_inn in ('ГПП 1','ГМП 1','ГМП 2','ГМП 3','ГМП 4')
--   and max_is_active_holding = 0
--   and max_is_active_inn = 1
  and manager_group_holding <> manager_group_inn    -- Мираторг, CoCoCo
