select cntr.which_crm,
       case when which_crm in (6,8) then cntr.country end as country,
       case when which_crm in (6,8) then cntr.manager_group end as manager_group,
       count(distinct coalesce(client_id,corp_contract_id)) as clients_cnt,
       count(distinct corp_contract_id) as contracts_cnt,
       sum(n_deliveries_visited) as dlv_cnt
from snb_taxi.logdata_dm_order_v
  left join snb_taxi.niksm_b2b_contracts_info as cntr
    on corp_contract_id = contract_id
where utc_order_dt >= current_date-60
  and corp_order_flg
  and success_order_flg
  and logistic_tariff_flag
group by 1,2,3
order by 1,2,3;

select date_trunc('week',moscow_order_dt)::date as calweek,
       client_name,
       sum(n_deliveries_visited) as dlv_cnt
from snb_taxi.logdata_dm_order_v
  left join snb_taxi.niksm_b2b_contracts_info as cntr
    on corp_contract_id = contract_id
where utc_order_dt >= '2021-01-01'
  and corp_order_flg
  and success_order_flg
  and logistic_tariff_flag
  and manager_group in ('ГПП 1','ГПП 2')
group by 1,2;
