create or replace view snb_delivery.claim_segment_special_requirements as
select claim_id,
       claim_segment_id,
       taxi_order_id,
       utc_created_dttm,
       virtual_tariffs_json ->> 'class' as tariff_class_code,
       json_array_elements(virtual_tariffs_json -> 'special_requirements') ->> 'id' as req_id
from (
    select claim_id,
           claim_segment_id,
           taxi_order_id,
           utc_created_dttm,
           json_array_elements(special_requirement_text::json -> 'virtual_tariffs') as virtual_tariffs_json
    from delivery_ods_cargo_claims.claim_segment
) q;
comment on view snb_delivery.claim_segment_special_requirements is 'Развертка special_requirements из claim_segment';
