drop view if exists snb_b2b.niksm_b2b_logdata496;
create or replace view snb_b2b.niksm_b2b_logdata496 as
with blnc as (
    select billing_contract_id,
           contract_external_id,
           person_inn,
           client,
           contract_type,
           payment_type,
           is_active as billing_contract_is_active,
           start_dt,
           greatest(
               coalesce(start_dt, '2099-12-31'::date),
               least(
                   coalesce(faxed_dt, '2099-12-31'::date),
                   coalesce(signed_dt, '2099-12-31'::date)
                   )
               ) as start_dt_exp,
           case
               when contract_type = 'Договор-оферта' then min_payment_date_v2
               when payment_type = 'предоплата' then start_dt
               else least(signed_dt, faxed_dt, booked_dt)
            end as activated_dt,
           coalesce(least(finish_dt, cancelled_dt, suspended_dt), '2099-12-31'::date) as finish_dt_exp,
           legal_contract_cargo,
           legal_contract_taxi,
           start_dt = min(start_dt) over (partition by person_inn) as first_contract_flg
    from snb_b2b.niksm_b2b_balance_contract_info
)
select blnc.billing_contract_id,
       blnc.contract_external_id,
       person_inn,
       case
        when blnc.contract_type = 'Не агентский' then
           case when blnc.payment_type = 'постоплата' then 'Договор постоплата'
               when blnc.payment_type = 'предоплата' then
                case when coalesce(lk_contract_prepaid_deactivate_threshold<0,false)
                    then 'Договор квази постоплата' else 'Договор предоплата' end
               end
        when blnc.contract_type = 'Договор-оферта' then
            case when blnc.payment_type = 'предоплата' then
                case when coalesce(lk_contract_prepaid_deactivate_threshold<0,false)
                    then 'Оферта квази постоплата' else 'Оферта предоплата' end
               end
        end as contract_type_exp,
       blnc.contract_type,
       blnc.payment_type,
       blnc.billing_contract_is_active,
       case when legal_contract_cargo = 1 then 'ООО Яндекс.Доставка'
           when legal_contract_taxi = 1 then 'ООО Яндекс.Такси'
               end as legal_entity,
       start_dt,
       start_dt_exp,
       activated_dt,
       finish_dt_exp,
       first_contract_flg,
       --
       lk_cargo_is_active,
       --
       manager_group,
       lead_name,
       coalesce(manager_name,manager_login) as manager_name,
       which_crm,
       deal_id,
       client_name,
       permissions
from blnc
  join snb_b2b.niksm_b2b_contracts_info as crm
    on crm.contract_id = blnc.contract_external_id
  left join snb_b2b.niksm_b2b_lk_contract_info as lk
    on lk.contract_external_id = blnc.contract_external_id
where true
  and which_crm = 6
  and manager_group in ('ГМП 1','ГМП 2','ГМП 3','ГМП 4','ГПП 1','СНГ РБ','СНГ РК','Тир 3')
  and start_dt between current_date-90 and current_date-1;


-- select count() from snb_b2b.niksm_b2b_logdata496;
--
--
-- select start_dt, count()
-- from snb_taxi.niksm_b2b_balance_contract_info
-- group by start_dt
-- order by 1 desc;
--
-- select *
-- from snb_b2b.voytekh_corporate_contracts_and_debts
-- -- where start_dt = '2021-07-28';
-- where contract = '2198667/21';
