drop view if exists snb_b2b.niksm_b2b_leads_for_taxi;
create or replace view snb_b2b.niksm_b2b_leads_for_taxi as
select dls.lead_id::int as deal_id,
       dls.country::text as country,
       dls.city::text as city,
       dls.lead_name::text as deal_title,
       inn::text as inn,
       website::text as website,
       prs.name as person_name,
       prs.phone,
       prs.email,
       (_etl_processed_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as record_date,
       (utc_lead_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow')::date as add_date,
       pipeline_name::text as pipeline_name,
       dls.pipeline_status_name as stage_name
from snb_b2b.amo_leads_info dls
left join snb_b2b.amo_contacts_info prs  on dls.contact_id = prs.contact_id and dls.crm_source = prs.crm_source
where dls.crm_source in ('yandexdelivery')
  and dls.utc_lead_created_dttm <= _etl_processed_dttm - interval '14 days'
  and (dls.pipeline_name in ('ЗАПУСК И РАЗВИТИЕ','САМОСТОЯТЕЛЬНЫЕ КЛИЕНТЫ')
    or (dls.pipeline_name = 'ПОДКЛЮЧЕНИЕ'
        and dls.pipeline_status_name in ('ПЕРЕГОВОРЫ', 'ПРИНЯТО РЕШЕНИЕ', 'ЖДЕМ ДОГОВОР') )
    )
    and position('"Лид от платформы"' in dls.tags) = 0
    and position('"Лид от платформы new"' in dls.tags) = 0
    and position('"Перезаключение с Такси на Доставку"' in dls.tags) = 0;

grant select on snb_b2b.niksm_b2b_leads_for_taxi to "v-kats", "robot-taxi-tst-34943", "robot-taxi-prd-34943";
comment on view snb_b2b.niksm_b2b_leads_for_taxi is 'Лиды из CRM Доставки для передачи в B2B платформу. LOGDATA-611';

comment on column snb_b2b.niksm_b2b_leads_for_taxi.deal_id is 'Номер сделки в CRM';
comment on column snb_b2b.niksm_b2b_leads_for_taxi.country is 'Страна организации';
comment on column snb_b2b.niksm_b2b_leads_for_taxi.city is 'Город';
comment on column snb_b2b.niksm_b2b_leads_for_taxi.deal_title is 'Наименование сделки (заголовок)';
comment on column snb_b2b.niksm_b2b_leads_for_taxi.inn is 'ИНН/БИН';
comment on column snb_b2b.niksm_b2b_leads_for_taxi.website is 'Сайт организации';
comment on column snb_b2b.niksm_b2b_leads_for_taxi.person_name is 'Имя контакта (заголовок)';
comment on column snb_b2b.niksm_b2b_leads_for_taxi.phone is 'Список телефонов';
comment on column snb_b2b.niksm_b2b_leads_for_taxi.email is 'Список email';
comment on column snb_b2b.niksm_b2b_leads_for_taxi.record_date is 'Дата снепшота';
comment on column snb_b2b.niksm_b2b_leads_for_taxi.add_date is 'Дата заведения сделки';
