create or replace view snb_taxi.niksm_b2b_crm_cargo_contracts_hist as
with raw as (
    select which_crm,
           custom_fields ->> (
            case when which_crm = 6 then '5b46472f62d243f28c789cfa00dc4859a06973a8'
                 when which_crm = 8 then '3341b9466f34977fc2ec29c1d7afcd8dfa6d8bb9'
                end) as contract_id,
           record_date
    from snb_b2b.voytekh_pd2_deal_history
    where which_crm in (6,8)
)
select contract_id,
       bool_or(record_date = current_date) as contract_actual_flg
from raw
where true
  and contract_id <> ''
  and contract_id is not null
group by contract_id;

comment on view snb_taxi.niksm_b2b_crm_cargo_contracts_hist is 'Все встречавшиеся в истории номера договоров доставки CRM Yandex.Delivery и GlobalExpansion2021. LOGDATA-693';
comment on column snb_taxi.niksm_b2b_crm_cargo_contracts_hist.contract_id is 'Номер договора';
comment on column snb_taxi.niksm_b2b_crm_cargo_contracts_hist.contract_actual_flg is 'Присутствует ли договор в CRM на сегодня (current_date)';
grant select on snb_taxi.niksm_b2b_crm_cargo_contracts_hist to
    etl, bmiklaz, vposkonin, ankozik, akuznetsova13, sofyaantonova, ivanborisov,
    "kovalev-vtl", "robot-tableau-94", andrewocean, "robot-corploader", alekskadyshev, vovakorsunov;
