drop view if exists snb_delivery.niksm_b2b_logdata736;
create or replace view snb_delivery.niksm_b2b_logdata736 as
select fctm.utc_order_created_dttm,
       fctm.msk_order_created_dt,
       fctm.corp_contract_id,
       fctm.order_id,
       fctm.tariff_geo_zone_code,
       fctm.driver_status,
       fctm.user_status,
       fctm.success_order_flg,
       fctm.currency_code,
       fctm.transporting_distance_plan_km,
       fctm.gmv_amt,
       fctm.net_inflow_amt
from taxi_cdm_marketplace.fct_order_metric fctm
  join snb_b2b.niksm_b2b_deals_info_ltd crm
    on fctm.corp_contract_id = crm.contract_id
where crm.which_crm = 6
  and crm.market_segment = 'Рестораны и кафе'
  and fctm.tariff_geo_zone_code = 'krasnodar';

-- select *
-- from snb_delivery.niksm_b2b_logdata736
-- where utc_order_created_dttm >= '2021-08-31'    -- для скорости
--   and msk_order_created_dt between '2021-09-01' and current_date-1;

------------------------------------------------------------------------------------------------------------------------
-- LOGDATA-764
drop view snb_delivery.niksm_b2b_logdata764;
create or replace view snb_delivery.niksm_b2b_logdata764 as
select contract_id,
       calday,
       deliveries_total,
       deliveries_cnt,
       deliveries_found,
       deliveries_a_arrived,
       deliveries_a_visited,
       deliveries_cancelled,
       dlv_for_searching_time,
       searching_time_sec,
       dlv_for_driving_to_a_time,
       driving_to_a_time_sec,
       dlv_for_arrival_time,
       arrival_time_sec,
       dlv_for_waiting_a_time,
       waiting_a_time_sec,
       dlv_for_transporting_time,
       transporting_time_sec,
       dlv_for_total_time,
       total_time_sec,
       dlv_for_cancellation_time,
       cancellation_time_sec,
       dlv_for_cancellation_before_found_time,
       cancellation_before_found_time_sec,
       last_full_date
from snb_b2b.niksm_dash_logdata111
where market_segment = 'Рестораны и кафе'
  and city = 'Краснодар';

-- select *
-- from snb_delivery.niksm_b2b_logdata764
-- where calday >= '2021-09-01';
--
-- select contract_id,
--        sum(deliveries_found) / nullif(sum(deliveries_total),0) as "Курьер найден, %",
--        sum(searching_time_sec) / nullif(sum(dlv_for_searching_time),0) as "Время поиска"
-- from snb_delivery.niksm_b2b_logdata764
-- where calday between date_trunc('week',current_date-1) and current_date-1
-- group by contract_id;
