-- drop table if exists niksm_temp_835_claim_statlog;
-- create temporary table niksm_temp_835_claim_statlog as
-- --
-- select claim_id,
--    min(case when new_claim_status = 'pickup_arrived' then utc_created_dttm end)  as utc_a_arrived_dttm,
--    min(case when new_claim_status in ('cancelled', 'cancelled_with_items_on_hands', 'cancelled_with_payment') then utc_created_dttm end) as utc_cancelled_dttm
-- from delivery_ods_cargo_claims.claim_status_log
-- where true
-- and utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
-- group by claim_id
-- distributed by (claim_id);
-- --
-- analyze niksm_temp_835_claim_statlog;

drop view snb_b2b.niksm_vv_sla_hourly_logdata835;
create or replace view snb_b2b.niksm_vv_sla_hourly_logdata835 as
with claim_statlog as (
    select claim_id,
       min(case when new_claim_status = 'accepted' then utc_created_dttm end) as utc_accepted_dttm,
       min(case when new_claim_status = 'pickup_arrived' then utc_created_dttm end) as utc_a_arrived_dttm,
       min(case when new_claim_status in ('cancelled', 'cancelled_with_items_on_hands', 'cancelled_with_payment') then utc_created_dttm end) as utc_cancelled_dttm
    from delivery_ods_cargo_claims.claim_status_log
    where true
      and utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
    group by claim_id
    having bool_or( new_claim_status = 'accepted' )
)
, raw_claims as (
    select claim.corp_client_id,
           claim.tariff_zone,
           claim.claim_id,
           date_trunc('hour',claim.utc_created_dttm at time zone 'UTC' at time zone 'Europe/Moscow') as msk_created_hour,
           --
           claim.utc_due_dttm is null or claim.utc_due_dttm <= utc_accepted_dttm + interval '30 minutes' as soon_flg,
           claim_statlog.claim_id is not null as cargo_logging_flg,
           claim.utc_created_dttm as utc_created_dttm,
           utc_a_arrived_dttm,
           utc_cancelled_dttm,
           status_code,
           coalesce(utc_a_arrived_dttm <= utc_accepted_dttm + interval '20 minutes', False) as fast_arriving_flg,
           coalesce(utc_cancelled_dttm <= utc_accepted_dttm + interval '20 minutes', False) as fast_cancellation_flg,
           case when utc_a_arrived_dttm is not null then
               extract(epoch from utc_a_arrived_dttm - utc_accepted_dttm) end as arrival_time_sec
    from delivery_ods_cargo_claims.claim as claim
      left join /*niksm_temp_835_claim_statlog*/ claim_statlog
        on claim_statlog.claim_id = claim.claim_id
    where true
      and claim.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
      and claim.corp_client_id in (
            'ed7c330f45fe4706a5e16e4efd7042b5',
            'bf1919ef126346ba93a7542b541ef487',
            '5e8b0ed225f5417885dd8e68488f052a',
            '1e6f330c2c07459aaa7d443941cc15c6',
            '3bc44ac66a2648469522e4c1e75ed652',
            '87c36e369f76423cbc30fb6f36c43a08',
            'f208c4cd4a7d4204be09065ca6c7c9b8')
      and claim.tariff_zone is not null
)
, zn as (
    select distinct
           lk_client_id,
           lk_client_name,
           tariff_zone,
           contract_external_id
    from raw_claims
      join snb_b2b.niksm_b2b_lk_client_service_info lk
        on lk.lk_client_id = raw_claims.corp_client_id
        and lk_service_name = 'cargo'
)
, raw_hours as (
    select zn.lk_client_id,
           zn.lk_client_name,
           zn.tariff_zone, gen.msk_created_hour,
           --
           count(raw_claims.claim_id) as claims_cnt,
           sum(case when not soon_flg then 1 else 0 end) as delayed_claims_cnt,
           sum(case when soon_flg and not cargo_logging_flg then 1 else 0 end) as nologging_claims_cnt,
           sum(case when soon_flg and cargo_logging_flg and fast_cancellation_flg then 1 else 0 end) as fast_cancelled_claims_cnt,
           sum(case when soon_flg and cargo_logging_flg and not fast_cancellation_flg then 1 else 0 end) as base_claims_cnt,
           sum(case when soon_flg and cargo_logging_flg and not fast_cancellation_flg and fast_arriving_flg then 1 else 0 end) as fast_arriving_claims_cnt,
           sum(case when soon_flg and cargo_logging_flg and not fast_cancellation_flg and utc_cancelled_dttm is not null then 1 else 0 end) as late_cancelled_claims_cnt,
           sum(case when soon_flg and cargo_logging_flg and not fast_cancellation_flg and status_code in ('failed','performer_not_found') then 1 else 0 end) as not_found_claims_cnt,
           --
           sum(case when soon_flg and cargo_logging_flg and not fast_cancellation_flg and arrival_time_sec is not null then 1 else 0 end) as base_claims_arrived_cnt,
           sum(case when soon_flg and cargo_logging_flg and not fast_cancellation_flg then arrival_time_sec else 0 end) as arriving_time_sec,
           --
           coalesce(sum(count(raw_claims.claim_id)) over (
               partition by zn.lk_client_id, zn.tariff_zone, extract(hour from gen.msk_created_hour) order by gen.msk_created_hour::date range between 7 preceding and 7 preceding),0)
               as claims_cnt_prev,
           max(permissions) as permissions
    from zn
      cross join generate_series(
              date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day',
              date_trunc('hour', current_timestamp at time zone 'Europe/Moscow'),
              interval '1 hour') as gen(msk_created_hour)
      left join raw_claims
        on raw_claims.corp_client_id = zn.lk_client_id
        and raw_claims.tariff_zone = zn.tariff_zone
        and raw_claims.msk_created_hour = gen.msk_created_hour
      left join snb_b2b.niksm_b2b_contracts_info crm
        on crm.contract_id = contract_external_id
    group by zn.lk_client_id, zn.lk_client_name,
           zn.tariff_zone, gen.msk_created_hour
)
select lk_client_id, lk_client_name,
       tariff_zone, msk_created_hour,
       --
       claims_cnt, delayed_claims_cnt, nologging_claims_cnt, fast_cancelled_claims_cnt,
       base_claims_cnt, fast_arriving_claims_cnt,
       late_cancelled_claims_cnt, not_found_claims_cnt,
--        fast_arriving_claims_cnt::double precision / nullif(base_claims_cnt,0) as fast_arriving_share,
--        late_cancelled_claims_cnt::double precision / nullif(base_claims_cnt,0) as late_cancelled_share,
--        not_found_claims_cnt::double precision / nullif(base_claims_cnt,0) as not_found_share,
       claims_cnt_prev,
--        claims_cnt::double precision / nullif(claims_cnt_prev,0)-1. as claims_growth,
--        claims_cnt >= claims_cnt_prev*1.25 as claims_extreme_growth_flg,
--        claims_cnt < claims_cnt_prev*1.25
--            and fast_arriving_claims_cnt < 0.95 * base_claims_cnt as sla_failed_flg,
       base_claims_arrived_cnt, arriving_time_sec,
       permissions
from raw_hours
where msk_created_hour >= current_date-14
-- order by tariff_zone, msk_created_hour
;

comment on view snb_b2b.niksm_vv_sla_hourly_logdata835 is 'Данные для дашборда Delivery SLA Hourly. Тикет LOGDATA-835';

------------------------------------------------------------------------------------------------------------------------

select * from snb_b2b.niksm_vv_sla_hourly_logdata835;

select max(utc_created_dttm) at time zone 'UTC' from delivery_ods_cargo_claims.claim;

select lk_client_id, sum(claims_cnt)
from snb_b2b.niksm_vv_sla_hourly_logdata835
where tariff_zone = 'moscow'
group by 1;

select lk_client_id,
       max(lk_client_name),
--        order_source_code,
--        tariff_geo_zone_code,
       count() cnt
from taxi_cdm_marketplace.fct_order
  join snb_b2b.niksm_b2b_lk_client_service_info lk
    on lk.lk_client_id = fct_order.corp_client_id
    and lk_service_name = 'cargo'
  join snb_taxi.logdata_logistic_tariffs
    on order_tariff = tariff_class_code
where true
  and utc_order_created_dttm >= current_date-21
--   and corp_client_id = 'ed7c330f45fe4706a5e16e4efd7042b5'
  and success_order_flg
group by 1
order by cnt desc;


select lk_client_id,
       max(lk_client_name),
       order_source_code,
       tariff_geo_zone_code,
       count() cnt
from taxi_cdm_marketplace.fct_order
  join snb_b2b.niksm_b2b_lk_client_service_info lk
    on lk.lk_client_id = fct_order.corp_client_id
    and lk_service_name = 'cargo'
  join snb_taxi.logdata_logistic_tariffs
    on order_tariff = tariff_class_code
where true
  and utc_order_created_dttm >= current_date-21
  and corp_client_id = 'bf1919ef126346ba93a7542b541ef487'
  and success_order_flg
group by 1,3,4
order by cnt desc;


select *
-- from delivery_ods_cargo_claims.claim_segment_status_log
from delivery_ods_cargo_claims.claim_status_log
where utc_created_dttm >= current_date-30
  and claim_id = 71997528
order by utc_created_dttm
;

select claim.claim_id,
       claim.utc_created_dttm,
       segm.utc_created_dttm
--        count(distinct claim_segment_id)
from delivery_ods_cargo_claims.claim as claim
  join delivery_ods_cargo_claims.claim_segment segm
    on claim.claim_id = segm.claim_id
where true
  and claim.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
  and  segm.utc_created_dttm >= (date_trunc('day', current_timestamp at time zone 'Europe/Moscow') - interval '21 day') at time zone 'Europe/Moscow' at time zone 'UTC'
  and claim.corp_client_id = 'ed7c330f45fe4706a5e16e4efd7042b5'
--   and (claim.utc_due_dttm is null or claim.utc_due_dttm <= claim.utc_created_dttm + interval '30 minutes')
  and abs(extract(epoch from claim.utc_created_dttm - segm.utc_created_dttm)) > 60
-- group by 1
-- having count(distinct claim_segment_id)>1
limit 50
