drop view if exists snb_b2b.niksm_dash_gmv_yd_share;
create or replace view snb_b2b.niksm_dash_gmv_yd_share as
select msk_order_created_dt as calday,
       manager_metagroup,
       manager_group,
       case when legal_contract_cargo = 1 then 'ООО Яндекс.Доставка'
           when legal_contract_taxi = 1 then 'ООО Яндекс.Такси'
           end as legal_entity,
       blnc.payment_type,
       country_name_ru,
       --
       sum(gmv_amt * coalesce(currency_rate,1.)) as gmv_rub,
       sum(gmv_amt) as gmv_lcy,
       sum(delivery_point_cnt) as deliveries_cnt,
       max(msk_order_created_dt) over () as calday_last
from taxi_cdm_marketplace.fct_order_metric fct
  join snb_delivery.logdata_delivery_tariff
    on order_tariff = tariff_class_code
    and utc_order_created_dttm between utc_datefrom and utc_dateto
  join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = fct.corp_contract_id
  join snb_b2b.amo_contracts_info crm
    on crm.contract_id = fct.corp_contract_id
where utc_order_created_dttm >= '2021-07-31'
  and msk_order_created_dt between '2021-08-01' and current_date-1
  and success_order_flg
  and corp_order_flg
  and crm.crm_source = 'yandexdelivery'
  and manager_metagroup in ('ГПП','ГМП','СНГ','Тир 3')
  and (legal_contract_taxi = 1 or legal_contract_cargo = 1)
  and not crm.contract_terminated_flg
group by 1,2,3,4,5,6;

comment on view snb_b2b.niksm_dash_gmv_yd_share is 'LOGDATA-838';

------------------------------------------------------------------------------------------------------------------------
drop view if exists snb_b2b.niksm_dash_gmv_yt_contracts;
create or replace view snb_b2b.niksm_dash_gmv_yt_contracts as
select blnc.contract_external_id,
       blnc.client as billing_client_name,
       case when blnc.is_active=1 then 'Active' else 'Deactivated' end as billing_contract_status,
       country_name_ru,
       manager_metagroup, manager_group, teamlead_name, manager_name, manager_login,
       currency_code,
       --
       sum(gmv_amt * coalesce(currency_rate,1.)) as gmv_rub,
       sum(gmv_amt) as gmv_lcy,
       sum(delivery_point_cnt) as deliveries_cnt,
       max(case when gmv_amt>0 then msk_order_created_dt end) as last_delivery_date
from taxi_cdm_marketplace.fct_order_metric fct
  join snb_taxi.logdata_logistic_tariffs
    on order_tariff = tariff_class_code
  join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = fct.corp_contract_id
  join snb_b2b.amo_contracts_info crm
    on crm.contract_id = fct.corp_contract_id
where utc_order_created_dttm >= current_date - 8
  and msk_order_created_dt between current_date - 7 and current_date-1
  and success_order_flg
  and corp_order_flg
  and crm.crm_source = 'yandexdelivery'
  and manager_metagroup in ('ГПП','ГМП','СНГ','Тир 3')
  and not crm.contract_terminated_flg
  and legal_contract_taxi = 1
group by blnc.contract_external_id,
         blnc.client,
         case when blnc.is_active=1 then 'Active' else 'Deactivated' end,
         country_name_ru,
         manager_metagroup, manager_group, teamlead_name, manager_name, manager_login,
         currency_code
having sum(gmv_amt)>0;
--
comment on view snb_b2b.niksm_dash_gmv_yt_contracts is 'Список клиентов с GMV по договору Я.Такси в выбранных тирах за последние 7 дней. LOGDATA-1496';
