drop view if exists snb_delivery.niksm_b2b_client_manager;
create or replace view snb_delivery.niksm_b2b_client_manager as
with dlv as (
    select corp_contract_id,
           sum(delivery_point_cnt) as deliveries_cnt
    from taxi_cdm_marketplace.fct_order
      join snb_delivery.logdata_delivery_tariff
        on order_tariff = tariff_class_code
        and utc_order_created_dttm between utc_datefrom and utc_dateto
    where utc_order_created_dttm >= current_date - 31
      and success_order_flg
      and corp_order_flg
      and msk_order_created_dt between current_date-30 and current_date-1
    group by 1
)
select client_name,
       contract_id,
       manager_login,
       manager_name,
       lead_name,
       manager_group,
       website,
       coalesce(deliveries_cnt,0) as deliveries_cnt
from snb_b2b.niksm_b2b_contracts_info crm
  left join dlv
    on contract_id = corp_contract_id
where which_crm = 6
  and manager_group in ('ГПП 1','ГПП 2','ГМП 1','ГМП 2','ГМП 3','ГМП 4','ГМП NDD','Партнерские продажи');

revoke select on snb_delivery.niksm_b2b_client_manager from ro_snb_delivery, rw_snb_delivery;
grant select on snb_delivery.niksm_b2b_client_manager to ro_snb_b2b, korollevae, diskhakova;

comment on view snb_delivery.niksm_b2b_client_manager is 'Связка корп клиента по наименованию с менеджером. LOGDATA-961';
comment on column snb_delivery.niksm_b2b_client_manager.client_name is 'Имя группы компаний или организации из CRM';
