drop view if exists snb_delivery.niksm_b2b_top_client_id;
create or replace view snb_delivery.niksm_b2b_top_client_id as
select comp_list.company_group,
       crm.deal_title,
       lk.lk_client_id as corp_client_id,
       lk.contract_external_id,
       crm.manager_login as deal_manager_login,
       crm.manager_name as deal_manager_name
from snb_delivery.e_solovev_alerts_config_test_company_groups comp_list
  join snb_b2b.niksm_b2b_contracts_info crm
    on trim(trailing from crm.holding_name) = trim(trailing from comp_list.company_group)
  join snb_b2b.niksm_b2b_lk_contract_info lk
    on lk.contract_external_id = crm.contract_id;

revoke select on snb_delivery.niksm_b2b_top_client_id from ro_snb_delivery, rw_snb_delivery;
revoke select on snb_delivery.niksm_b2b_top_client_id from ro_snb_delivery, rw_snb_delivery;
grant select on snb_delivery.niksm_b2b_top_client_id to ro_snb_b2b, "e-solovev", "zhukov-vlad", "robot-log-analytics", "ev-logvinenko";
