drop view if exists snb_delivery.niksm_dlv_7d;
create or replace view snb_delivery.niksm_dlv_7d as
with fct as (
    select msk_order_created_dt as moscow_order_dt,
           sum(delivery_point_cnt) as dlv_cnt,
           sum(case when corp_order_flg  then delivery_point_cnt end) as dlv_cnt_corp,
           sum(corp_order_flg::int) as orders_cnt_corp
    from taxi_cdm_marketplace.fct_order
      join snb_delivery.logdata_delivery_tariff
        on order_tariff = tariff_class_code
        and utc_order_created_dttm between utc_datefrom and utc_dateto
    where utc_order_created_dttm between current_date-16 and current_date+1
      and success_order_flg
    group by 1
)
, raw as (
    select moscow_order_dt,
           to_char(fct.dlv_cnt,'999,999,999')
               || ' (' || coalesce( to_char(
                       (fct.dlv_cnt /
                        nullif(
                            sum(fct.dlv_cnt) over (order by moscow_order_dt range between 1 preceding and 1 preceding)
                            ,0) - 1)
                   * 100,'SG990.9%') ,'')
               || ' ; ' || coalesce( to_char(
                       (fct.dlv_cnt /
                        nullif(
                            sum(fct.dlv_cnt) over (order by moscow_order_dt range between 7 preceding and 7 preceding)
                            ,0)  - 1)
                   * 100,'SG990.9%') ,'')
               || ')' as "Доставки (DoD; WoW) - fct_order",
           to_char(fct.dlv_cnt_corp,'999,999,999')
               || ' (' || coalesce( to_char(
                       (fct.dlv_cnt_corp /
                        nullif(
                            sum(fct.dlv_cnt_corp) over (order by moscow_order_dt range between 1 preceding and 1 preceding)
                            ,0)  - 1)
                   * 100,'SG990.9%') ,'')
               || ' ; ' || coalesce( to_char(
                       (fct.dlv_cnt_corp /
                        nullif(
                            sum(fct.dlv_cnt_corp) over (order by moscow_order_dt range between 7 preceding and 7 preceding)
                            ,0)  - 1)
                   * 100,'SG990.9%') ,'')
               || ')' as "Доставки B2B (DoD; WoW) - fct_order",
           to_char(fct.orders_cnt_corp,'999,999,999')
               || ' (' || coalesce( to_char(
                       (fct.orders_cnt_corp /
                        nullif(
                            sum(fct.orders_cnt_corp) over (order by moscow_order_dt range between 1 preceding and 1 preceding)
                            ,0)  - 1)
                   * 100,'SG990.9%') ,'')
               || ' ; ' || coalesce( to_char(
                       (fct.orders_cnt_corp /
                        nullif(
                            sum(fct.orders_cnt_corp) over (order by moscow_order_dt range between 7 preceding and 7 preceding)
                            ,0)  - 1)
                   * 100,'SG990.9%') ,'')
               || ')' as "Заказы B2B (DoD; WoW) - fct_order"
    from fct
)
select moscow_order_dt::text as moscow_order_dt,
       "Доставки (DoD; WoW) - fct_order",
       "Доставки B2B (DoD; WoW) - fct_order",
       "Заказы B2B (DoD; WoW) - fct_order"
from raw
where moscow_order_dt between current_date-7 and current_date-1
--
union all
select 'Время последней записи',
       to_char(max(t_fct.max_moscow_dttm),'YYYY-MM-DD HH24:MI'),
       to_char(max(t_fct.max_corp_moscow_dttm),'YYYY-MM-DD HH24:MI'),
       to_char(max(t_cc. max_moscow_dttm),'YYYY-MM-DD HH24:MI')         -- 'Время последней записи Cargo_claims'
from (
        select max(msk_order_created_dttm) as max_moscow_dttm,
               max(case when corp_order_flg  then msk_order_created_dttm end) as max_corp_moscow_dttm
        from taxi_cdm_marketplace.fct_order
        where utc_order_created_dttm between current_date-16 and current_date+1
    ) t_fct
    cross join (
        select max(utc_created_dttm) AT TIME ZONE 'UTC' AT TIME ZONE 'Europe/Moscow' as max_moscow_dttm
        from delivery_ods_cargo_claims.claim
        where utc_created_dttm between current_date-16 and current_date+1
    ) t_cc;
--
comment on view snb_delivery.niksm_dlv_7d is 'Доставки за 7 дней в fct_order';
