drop table if exists snb_b2b.egrocery_stats;
create table snb_b2b.egrocery_stats as
select coalesce(crm.holding_name,crm.company_name,crm.lead_name) as client_name,
       fct.tariff_zone,
       fct.source_address,
       fct.cargo_ref_id as DDI,
---
       sum(fct.deliveries_plan_cnt) as gross_deliveries,
       sum(fct.deliveries_cnt) as succeed_deliveries,
       case when sum(fct.deliveries_cnt) > 0 then
                    sum(fct.deliveries_plan_cnt)/sum(fct.deliveries_cnt) else 0 end as succ_coeff,
---
       fct.msk_created_dt,
       date_trunc('week',fct.msk_created_dt)::date as msk_created_week,
        date_trunc('month',fct.msk_created_dt)::date as msk_created_month,
---
        avg(case when (utc_found_dttm - utc_accepted_dttm  > interval '0 seconds') then
                     (EXTRACT(hour FROM utc_found_dttm - utc_accepted_dttm)*60+EXTRACT(minutes FROM utc_found_dttm - utc_accepted_dttm)+EXTRACT(seconds FROM utc_found_dttm - utc_accepted_dttm)/60)
                 else null end) as avg_routing,

       sum(
               case when utc_a_arrived_dttm - utc_found_dttm > interval '20 minutes' then 1
               when utc_a_arrived_dttm - utc_found_dttm <= interval '20 minutes' then 0
               else null
               end ) as Bad_ATA,
       sum(
               case when utc_b_visited_last_dttm - utc_a_visited_dttm > interval '40 minutes' then 1
               when utc_b_visited_last_dttm - utc_a_visited_dttm < interval '40 minutes' then 0
               else null
               end) as Bad_TOD,
       ---vendor
       sum(
               case when (utc_cancelled_dttm > utc_accepted_dttm) and (claim_status_code in ('cancelled','cancelled_with_items_on_hands','cancelled_with_payment')) then 1
                    else null end) as cancelled_on_the_way,
       cast(avg(transporting_distance_plan_km) as double precision) as avg_distance,
       avg(gmv_rub) as avg_gmv,
       sum(net_inflow_rub) as NI,
       case when (count(distinct claim_id) over (partition by order_id) > 1) then sum(deliveries_cnt) else null end
           as batching

from snb_delivery.niksm_fct_delivery fct
         join snb_b2b.dbcorp_client_info lk
              on lk.corp_client_id = fct.corp_client_id
         join snb_b2b.amo_contracts_info crm
              on crm.contract_id = lk.corp_contract_id
where true
  and fct.utc_created_dttm >= now()::date - interval '1 months'
  and crm.crm_source = 'yandexdelivery'
  and crm.market_segment = 'E-grocery'
group by 1,2,3,4,8,9,10, order_id, claim_id;

grant select on snb_b2b.egrocery_stats to "robot-taxi-stat";