select case
            when corp_client_id = '4decd14f25424e8b82b6d3e4f56d23b2' then 'рестораны РФ'
            when corp_client_id = 'b2dc2b2e96f8482ba2d1582bd1445184' then 'ритейл РФ'
            when corp_client_id = '162b9899216246f7a1ba9fc14a479e87' then 'еда BY'
            when corp_client_id = '87cda4c03d60416bb522e83fe24b3d50' then 'еда РК'
       end as corp_client,
       country_name_ru,
       tariff_geo_zone_code,
       source_address,
       success_order_flg,
       count(order_id)
from taxi_cdm_marketplace.fct_order
         where utc_order_created_dttm between '2021-11-01' and '2021-11-07'
           and corp_order_flg
           and tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp', 'ubernight')
           and not mqc_order_flg
           and not fake_order_flg
           --and success_order_flg
           and corp_client_id in ('4decd14f25424e8b82b6d3e4f56d23b2', 'b2dc2b2e96f8482ba2d1582bd1445184',
                                  '162b9899216246f7a1ba9fc14a479e87' , '87cda4c03d60416bb522e83fe24b3d50')
group by 1, 2, 3, 4, 5
order by 1, 2, 3, 4, 5;


-- version II Более полная и на клеймах, что включает в себя Заявки на доставку из Я.Еды, которые не доходят до Я.Доставки

select
       case
            when cl.corp_client_id = '4decd14f25424e8b82b6d3e4f56d23b2' then 'рестораны РФ'
            when cl.corp_client_id = 'b2dc2b2e96f8482ba2d1582bd1445184' then 'ритейл РФ'
            when cl.corp_client_id = '162b9899216246f7a1ba9fc14a479e87' then 'еда BY'
            when cl.corp_client_id = '87cda4c03d60416bb522e83fe24b3d50' then 'еда РК'
       end as corp_client,
       case
           when cl.status_code = 'delivered_finish' then 'delivered_finish'
               else 'not_delivered' end as status,
       po.city_name_ru,
             case when po.contact_name_ru in ('Макдоналдс', 'МакДональдс', 'McDonald''s') then 'Макдоналдс'
                 when po.contact_name_ru in ('Бургер Кинг', 'Бургер Кинг.Логист', 'Burger King') then 'Бургер Кинг'
                 when po.contact_name_ru in ('Азбука вкуса', 'Азбука daily') then 'Азбука вкуса'
                 when po.contact_name_ru in ('Zotman Pizza', 'Zotman pizza') then 'Zotman Pizza'
                 when po.contact_name_ru in ('Теремок', 'Теремок. Блины', 'Теремок. Кондитерская хорошего настроения') then 'Теремок'
                 else po.contact_name_ru
                 end contact_name_ru,
             po.point_full_address,
             po.country_name_ru,
       count(cl.claim_id)
from delivery_ods_cargo_claims.claim cl
join delivery_ods_cargo_claims.claim_point cp using(claim_id)
join delivery_ods_cargo_claims.point po on po.point_id = cp.point_id
where cl.utc_created_dttm between '2021-10-18' and '2021-10-24'
  and cp.utc_created_dttm between '2021-10-18' and '2021-10-24'
and cl.corp_client_id in ('4decd14f25424e8b82b6d3e4f56d23b2', 'b2dc2b2e96f8482ba2d1582bd1445184',
                                  '162b9899216246f7a1ba9fc14a479e87' , '87cda4c03d60416bb522e83fe24b3d50')
and cp.point_type = 'source'
group by 1, 2, 3, 4, 5, 6
;