with raw_inn_kpp as (
    select lk_client_id as corp_client_id, -- corp_client_id в остальных пестах
           lk_client_name,                 -- название организации
           person_inn
    from snb_b2b.niksm_b2b_lk_client_service_info
             left join snb_taxi.niksm_b2b_balance_contract_ext_info using (contract_external_id)
    group by 1, 2, 3
),
raw_data as (select
       lk_client_name,
       person_inn,
       case
           when status in ('delivered_finish', 'returned_finish') then 'delivered'
           else 'non delivered' end as status,
       referral_source,
       date_trunc('month', to_timestamp(created_ts) at time zone 'Europe/Moscow') as created_month,
       count (distinct id) as cnt_delivery
from snb_taxi.ferenec_integration_claim
         left join raw_inn_kpp using (corp_client_id)
where referral_source in ('1C', '1С УФА', '1С УФФ', 'Joomla - 1.4.0', 'Joomla - 1.5.0', 'Joomla - 1.6.1', 'Joomla - 1.7.0',
'Joomla - 1.7.1', 'OpenCart – 1.10.0', 'OpenCart – 1.10.1', 'OpenCart – 1.10.2', 'OpenCart – 1.11.0',
'OpenCart – 1.11.1', 'OpenCart – 1.11.3', 'OpenCart – 1.11.4', 'OpenCart – 1.4.0', 'OpenCart – 1.5.0',
'OpenCart – 1.8.0', 'OpenCart – 1.8.1', 'OpenCart – 1.9.0', 'RetailCRM', 'Shipit', 'Tillypad',
'WooCommerce - 1.10.0', 'WooCommerce - 1.10.1', 'WooCommerce - 1.10.2', 'WooCommerce - 1.10.3', 'WooCommerce - 1.10.4',
'WooCommerce - 1.10.5', 'WooCommerce - 1.11.0', 'WooCommerce - 1.11.1', 'WooCommerce - 1.11.2', 'WooCommerce - 1.7.0',
'WooCommerce - 1.7.1', 'WooCommerce - 1.8.0', 'WooCommerce - 1.8.1', 'WooCommerce - 1.8.2', 'WooCommerce - 1.8.3',
'WooCommerce - 1.8.4', 'WooCommerce - 1.9.0', 'alltrades', 'api_1c-bitrix', 'api_1c-bitrix_by', 'api_1c-bitrix_kz',
'apiship', 'iiko', 'mabali', 'rkeeper', 'shopify', 'smartomato')
group by 1, 2, 3, 4, 5),
raw_cohort as (select *,
       min(created_month) over (partition by lk_client_name, person_inn, referral_source) as first_month,
            date_part('month', age(created_month,
                min(created_month) over (partition by lk_client_name, person_inn, referral_source)) ) as diff_month,
            date_part('year', age(created_month,
                min(created_month) over (partition by lk_client_name, person_inn, referral_source)) ) as diff_year
from raw_data)
select referral_source,
       first_month,
       status,
       created_month as month_delivery,
       diff_year * 12 + diff_month as live_time,
       count(distinct person_inn) as cnt_client,
       sum(cnt_delivery) as cnt_delivery
from raw_cohort
--where status = 'delivered' --and referral_source in ('api_1c-bitrix_kz', 'Giftcraft')
group by 1, 2, 3, 4, 5;