with partition_fct_order as (
    select corp_contract_id,
           order_id,
           corp_client_id,
           utc_order_created_dt,
           (min(utc_order_created_dt)
            over (partition by corp_contract_id order by utc_order_created_dt))::date as first_order
    from taxi_cdm_marketplace.fct_order
    where (utc_order_created_dttm + interval '3 hours')::date between '2021-08-01' and (current_date - interval '1 day')
      and corp_order_flg
      and (tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp')
        or (tariff_class_code = 'ubernight' and utc_order_created_dttm >= '2021-09-01'))
      and not mqc_order_flg
      and not fake_order_flg
      and success_order_flg),
     age_fct_order as (
         select *, DATE_PART('month', age(utc_order_created_dt::date, first_order::date)) diff_month
         from partition_fct_order)
select corp_client_id,
       count(case when diff_month = 0 then order_id end) as cnt_first_month_order,
       bool_or(diff_month > 0)                           as second_month_order
from age_fct_order
group by corp_client_id
;