-- Part I
with raw_inn_kpp as (
    select contract_external_id,
           person_inn
    from (
        select blnc.contract_external_id,
               person_inn,
               count(crm.contract_id) over (partition by person_inn) as cnt
        from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
          left join snb_b2b.niksm_b2b_contracts_info crm
            on crm.contract_id = blnc.contract_external_id
            and which_crm = 6
        ) q
    where cnt > 0
),
 agg_order as (
     select date_trunc('month', msk_order_created_dt)::date as month_order,
            person_inn,
            count() as cnt_order
     from taxi_cdm_marketplace.fct_order
       join raw_inn_kpp
           on fct_order.corp_contract_id = raw_inn_kpp.contract_external_id
     where utc_order_created_dttm >= '2019-07-01'
       and msk_order_created_dt < '2021-11-01'
       and corp_order_flg
       and (tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp')
         or (tariff_class_code = 'ubernight' and utc_order_created_dttm >= '2021-09-01'))
       and not mqc_order_flg
       and not fake_order_flg
       and success_order_flg
     group by 1, 2
),
 cohort_raw as (
     select month_order,
            person_inn,
            min(month_order) over (partition by person_inn) as first_month,
            date_part('month', age(month_order,
                min(month_order) over (partition by person_inn)) ) as diff_month,
            date_part('year', age(month_order,
                min(month_order) over (partition by person_inn)) ) as diff_year
     from agg_order
 )
select first_month, diff_month, diff_year, count(person_inn)
from cohort_raw
group by 1, 2, 3;


-- Part II
with raw_inn_kpp as (
    select contract_external_id,
           person_inn
    from (
        select blnc.contract_external_id,
               person_inn,
               count(crm.contract_id) over (partition by person_inn) as cnt
        from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
          left join snb_b2b.niksm_b2b_contracts_info crm
            on crm.contract_id = blnc.contract_external_id
            and which_crm = 6
        ) q
    where cnt > 0
),
 agg_order as (
     select date_trunc('month', msk_order_created_dt)::date as month_order,
            person_inn,
            count() as cnt_order
     from taxi_cdm_marketplace.fct_order
       join raw_inn_kpp
           on fct_order.corp_contract_id = raw_inn_kpp.contract_external_id
     where utc_order_created_dttm >= '2021-10-01'
       and msk_order_created_dt < '2021-11-01'
       and corp_order_flg
       and (tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp')
         or (tariff_class_code = 'ubernight' and utc_order_created_dttm >= '2021-09-01'))
       and not mqc_order_flg
       and not fake_order_flg
       and success_order_flg
     group by 1, 2
)
select count(distinct person_inn)
from agg_order;