with a as (
    select claim_id,
           utc_created_dttm::date,
           json_array_elements(special_requirement_text::json -> 'virtual_tariffs') ->> 'class' as class,
           json_array_elements(json_array_elements(special_requirement_text::json -> 'virtual_tariffs') ->
                               'special_requirements') ->> 'id'                                 as sp_req
    from delivery_ods_cargo_claims.claim_segment
    where utc_created_dttm between '2021-11-12' and '2021-12-13'
)
, t as (
    select claim_id--, count(*) as cnt_cl_id
    from a
    where class = 'courier'
      and sp_req = 'car_couriers'
    group by claim_id
)

select cl.utc_created_dttm::date as date, t.claim_id is not null as pr
     , sum(final_price_w_vat_cur) as final_price_w_vat_cur
     , sum(final_price_wo_vat_cur) as final_price_wo_vat_cur
from delivery_ods_cargo_claims.claim as cl
left join t on cl.claim_id=t.claim_id
where utc_created_dttm between '2021-11-12' and '2021-12-13'
and cl.taxi_order_id is not null
group by cl.utc_created_dttm::date,  t.claim_id is not null
