with trf as (
    select corp_client_id as client_id,
           tariff_plan_name as tariff_plan_series_name
    from snb_b2b.dbcorp_client_tariff_plan_current
    where tariff_plan_series_id in
          ('a332ff55c1c64161a90bda46d0ad0a34', 'ec7753c8febe495caa132e6190ce1e31', 'ecf96b7eec8a4a1db4b8dc9cf6b15fae',
           'd3f2bff3d36245aa999c072fe73e9696', '8015578fdbb04989a0e06beabec5a5ef', 'e3fbe140c45647fb90bb7c9714048362',
           'b3e2a340beb44733b5347afa31857ab1', '9dc6852647e24d46915076f9336c39ec', 'a7d453e24d7d458d923c3c556c8b6558',
           '0ca32e88f2764459a119eaaa0bb1a652', '08c7c20b18b646c7bc1a91933181bdb0', 'aadf1f0f5fa54c49b884eda4d6e5bd02',
           '8f0b47a5295947988d5f4abd2cc73577', '95aa05b2c4d1482b825a2bb902f97ebe', '1acc79bf1dbe475097564b61d682a1dd',
           'aada3cf16c054b11ab6ccd799b4eef16', '9a4cd9a3f90f423eb675b43494b6517e', 'b7308dddf5a5466cb93fb39046244649',
           'a64a45c63e074819a4ee52d6db0f173b', '2e0e6eee37a04e6bb74f5e75d364774f', '2e0417cdd7f9495693596571801f5ca7')
      and service_name = 'cargo'
)
, client_attr as (
    select lk.lk_client_id as corp_client_id,
           lk_client_name,
           trf.client_id is not null as target_tariff_flg,
           tariff_plan_series_name,
           coalesce(crm.manager_group,'B2B платформа') as manager_group,
--            case when crm.market_segment in ('Рестораны и кафе','Цветы','E-grocery') then market_segment
--                else 'Others' end as
                market_segment
    from snb_b2b.niksm_b2b_lk_client_service_info lk
      left join snb_b2b.niksm_b2b_contracts_info crm
        on contract_id = lk.contract_external_id
      left join trf
        on lk.lk_client_id = trf.client_id
    where lk.lk_service_name = 'cargo'
      and (crm.contract_id is null
        or crm.manager_group not in ('INTERCO','ГПП 1','ГПП 2'))
)
, req as (
    select taxi_order_id,
           bool_or(req_id = 'car_couriers') as car_couriers_flg,
           bool_or(req_id in ('thermobag_confirmed', 'thermobag_delivery', 'thermobox_option_on')) as thermobag_flg
    from snb_delivery.claim_segment_special_requirements
    where utc_created_dttm >= current_date-45-1
      and tariff_class_code = 'courier'
    group by taxi_order_id
)
, dlv as (
    select fct.corp_client_id,
           --
           sum(case when car_couriers_flg then delivery_point_cnt else 0 end) as car_couriers_deliveries_cnt,
           sum(case when car_couriers_flg then delivery_point_cnt else 0 end)::double precision
               / nullif(sum(delivery_point_cnt),0.) as car_couriers_deliveries_share,
           sum(case when car_couriers_flg and thermobag_flg then delivery_point_cnt else 0 end) as car_couriers_thermobag_deliveries_cnt,
           sum(case when car_couriers_flg and thermobag_flg then delivery_point_cnt else 0 end)::double precision
               / nullif(sum(delivery_point_cnt),0.) as car_couriers_thermobag_deliveries_share,
           sum(delivery_point_cnt) as deliveries_cnt,
           sum(gmv_amt * coalesce(currency_rate,1.)) as gmv_rub,
           sum(net_inflow_amt * coalesce(currency_rate,1.)) as net_inflow_rub,
           sum(b2b_decoupling_amt * coalesce(currency_rate,1.)) as b2b_decoupling_rub
    from taxi_cdm_marketplace.fct_order_metric fct
      left join req
        on req.taxi_order_id = fct.order_id
    where utc_order_created_dttm >= current_date-45-1
      and msk_order_created_dt between current_date-45 and current_date-1
      and success_order_flg
      and country_name_ru = 'Россия'
      and tariff_class_code = 'courier'
    group by 1
)
-- список клиентов
-- select client_attr.corp_client_id,
--        lk_client_name,
--        target_tariff_flg,
--        tariff_plan_series_name,
--        manager_group,
--        market_segment,
--        car_couriers_deliveries_cnt, car_couriers_deliveries_share,
--        car_couriers_thermobag_deliveries_cnt, car_couriers_thermobag_deliveries_share,
--        deliveries_cnt,
--        gmv_rub, net_inflow_rub, b2b_decoupling_rub
-- from client_attr
--   left join dlv
--     on dlv.corp_client_id = client_attr.corp_client_id
-- where target_tariff_flg
-- order by deliveries_cnt desc

-- распил всех доставок до целевой группы
select case when tariff_class_code = 'courier' then tariff_class_code else 'others' end as tariff_class_code,
       case when corp_order_flg then 'B2B' else 'C2C' end as b2b_c2c,
       case when manager_group in ('INTERCO','ГПП 1','ГПП 2') then 'INTERCO+ГПП' else 'others' end as manager_group,
       trf.client_id is not null as target_tariff_flg,
       sum(case when car_couriers_flg then delivery_point_cnt else 0 end) as car_couriers_deliveries_cnt,
       sum(delivery_point_cnt) as deliveries_cnt
from taxi_cdm_marketplace.fct_order fct
  join snb_delivery.logdata_delivery_tariff
    on order_tariff = tariff_class_code
  left join req
    on req.taxi_order_id = fct.order_id
  left join snb_b2b.niksm_b2b_contracts_info crm
    on contract_id = corp_contract_id
  left join trf
    on fct.corp_client_id = trf.client_id
where utc_order_created_dttm >= current_date-45-1
  and msk_order_created_dt between current_date-45 and current_date-1
  and success_order_flg
  and country_name_ru = 'Россия'
 group by 1,2,3,4;

-- стата по сегментам рынка
with req as (
    select taxi_order_id,
           bool_or(req_id = 'car_couriers') as car_couriers_flg,
           bool_or(req_id in ('thermobag_confirmed', 'thermobag_delivery', 'thermobox_option_on')) as thermobag_flg
    from snb_delivery.claim_segment_special_requirements
    where utc_created_dttm >= current_date-45-1
      and tariff_class_code = 'courier'
    group by taxi_order_id
)
select market_segment,
       sum(case when car_couriers_flg then delivery_point_cnt else 0 end)::double precision
           / nullif(sum(delivery_point_cnt),0.) as car_couriers_deliveries_share,
       sum(case when car_couriers_flg and thermobag_flg then delivery_point_cnt else 0 end)::double precision
           / nullif(sum(delivery_point_cnt),0.) as car_couriers_thermobag_deliveries_share,
       sum(delivery_point_cnt) as deliveries_cnt
from taxi_cdm_marketplace.fct_order_metric fct
  join snb_b2b.niksm_b2b_contracts_info
    on contract_id = corp_contract_id
  left join req
    on req.taxi_order_id = fct.order_id
where utc_order_created_dttm >= current_date-45-1
  and msk_order_created_dt between current_date-45 and current_date-1
  and success_order_flg
  and country_name_ru = 'Россия'
  and tariff_class_code = 'courier'
  and which_crm = 6
  and manager_group not in ('INTERCO','ГПП 1','ГПП 2')
group by 1--,2,3,4,5 order by 1
;


-- ___________________________________________
-- Запрос для выгрузки

with trf as (
    select corp_client_id as client_id,
           tariff_plan_name as tariff_plan_series_name
    from snb_b2b.dbcorp_client_tariff_plan_current
    where tariff_plan_series_id in
          ('a332ff55c1c64161a90bda46d0ad0a34', 'ec7753c8febe495caa132e6190ce1e31', 'ecf96b7eec8a4a1db4b8dc9cf6b15fae',
           'd3f2bff3d36245aa999c072fe73e9696', '8015578fdbb04989a0e06beabec5a5ef', 'e3fbe140c45647fb90bb7c9714048362',
           'b3e2a340beb44733b5347afa31857ab1', '9dc6852647e24d46915076f9336c39ec', 'a7d453e24d7d458d923c3c556c8b6558',
           '0ca32e88f2764459a119eaaa0bb1a652', '08c7c20b18b646c7bc1a91933181bdb0', 'aadf1f0f5fa54c49b884eda4d6e5bd02',
           '8f0b47a5295947988d5f4abd2cc73577', '95aa05b2c4d1482b825a2bb902f97ebe', '1acc79bf1dbe475097564b61d682a1dd',
           'aada3cf16c054b11ab6ccd799b4eef16', '9a4cd9a3f90f423eb675b43494b6517e', 'b7308dddf5a5466cb93fb39046244649',
           'a64a45c63e074819a4ee52d6db0f173b', '2e0e6eee37a04e6bb74f5e75d364774f', '2e0417cdd7f9495693596571801f5ca7')
      and service_name = 'cargo'
)
, client_attr as ( -- инфа о клиенте
    select lk.lk_client_id as corp_client_id,
           lk_client_name,
           trf.client_id is not null as target_tariff_flg,
           tariff_plan_series_name,
           coalesce(crm.manager_group,'B2B платформа') as manager_group,
           case when crm.market_segment in ('Рестораны и кафе','Цветы','E-grocery') then market_segment
                else 'Others' end as market_segment
    from snb_b2b.niksm_b2b_lk_client_service_info lk
      left join snb_b2b.niksm_b2b_contracts_info crm
        on contract_id = lk.contract_external_id
      left join trf
        on lk.lk_client_id = trf.client_id
    where lk.lk_service_name = 'cargo'
      --and crm.contract_id is null
)
, req as ( -- спец требования
    select taxi_order_id,
           bool_or(req_id = 'car_couriers') as car_couriers_flg,
           bool_or(req_id in ('thermobag_confirmed', 'thermobag_delivery', 'thermobox_option_on')) as thermobag_flg
    from snb_delivery.claim_segment_special_requirements
    where utc_created_dttm >= current_date-65-1
      and tariff_class_code = 'courier'
    group by taxi_order_id
)
, dlv as (
    select fct.corp_client_id,
           msk_order_created_dt,
           tariff_class_code,
           --
           sum(case when car_couriers_flg then delivery_point_cnt else 0 end) as car_couriers_deliveries_cnt,
           sum(case when car_couriers_flg then delivery_point_cnt else 0 end)::double precision
               / nullif(sum(delivery_point_cnt),0.) as car_couriers_deliveries_share,
           sum(case when car_couriers_flg and thermobag_flg then delivery_point_cnt else 0 end) as car_couriers_thermobag_deliveries_cnt,
           sum(case when car_couriers_flg and thermobag_flg then delivery_point_cnt else 0 end)::double precision
               / nullif(sum(delivery_point_cnt),0.) as car_couriers_thermobag_deliveries_share,
           sum(delivery_point_cnt) as deliveries_cnt,
           sum(gmv_amt * coalesce(currency_rate,1.)) as gmv_rub,
           sum(net_inflow_amt * coalesce(currency_rate,1.)) as net_inflow_rub,
           sum(b2b_decoupling_amt * coalesce(currency_rate,1.)) as b2b_decoupling_rub
    from taxi_cdm_marketplace.fct_order_metric fct
      left join req
        on req.taxi_order_id = fct.order_id
    where utc_order_created_dttm >= current_date-65-1
      and msk_order_created_dt between current_date-65 and current_date-1
      and success_order_flg
      and country_name_ru = 'Россия'
      and tariff_class_code in  ('courier', 'express')
    group by 1, 2, 3
)
,
     exclude_list as (
         select corp_client_id,
                exclude_flg
         from snb_delivery.ferenec_car_couriers_pay
where exclude_flg = 1
)

select msk_order_created_dt,
       tariff_class_code,
       market_segment,
       tariff_plan_series_name,
       coalesce(target_tariff_flg, FALSE) as target_tariff_flg,
       case when manager_group in ('INTERCO','ГПП 1','ГПП 2') then 'INTERCO+ГПП' else 'others' end as manager_group,
       case when exclude_flg = 1 then TRUE else FALSE end as exclude_flg,
       sum(car_couriers_deliveries_cnt) as car_couriers_deliveries_cnt_sum,
       sum(car_couriers_thermobag_deliveries_cnt) as car_couriers_thermobag_deliveries_cnt_sum,
       sum(deliveries_cnt) as deliveries_cnt,
       sum(gmv_rub) as gmv_rub,
       sum(net_inflow_rub) as net_inflow_rub,
       sum(b2b_decoupling_rub) as b2b_decoupling_rub
from dlv
  left join client_attr
    on dlv.corp_client_id = client_attr.corp_client_id
  left join exclude_list
    on exclude_list.corp_client_id = dlv.corp_client_id
group by 1, 2, 3, 4, 5, 6, 7
;


---- вторая раскатка

with trf as (
    select corp_client_id as client_id,
           tariff_plan_name as tariff_plan_series_name
    from snb_b2b.dbcorp_client_tariff_plan_current
    where tariff_plan_series_id in
          ('a332ff55c1c64161a90bda46d0ad0a34', 'ec7753c8febe495caa132e6190ce1e31', 'ecf96b7eec8a4a1db4b8dc9cf6b15fae',
           'd3f2bff3d36245aa999c072fe73e9696', '8015578fdbb04989a0e06beabec5a5ef', 'e3fbe140c45647fb90bb7c9714048362',
           'b3e2a340beb44733b5347afa31857ab1', '9dc6852647e24d46915076f9336c39ec', 'a7d453e24d7d458d923c3c556c8b6558',
           '0ca32e88f2764459a119eaaa0bb1a652', '08c7c20b18b646c7bc1a91933181bdb0', 'aadf1f0f5fa54c49b884eda4d6e5bd02',
           '8f0b47a5295947988d5f4abd2cc73577', '95aa05b2c4d1482b825a2bb902f97ebe', '1acc79bf1dbe475097564b61d682a1dd',
           'aada3cf16c054b11ab6ccd799b4eef16', '9a4cd9a3f90f423eb675b43494b6517e', 'b7308dddf5a5466cb93fb39046244649',
           'a64a45c63e074819a4ee52d6db0f173b', '2e0e6eee37a04e6bb74f5e75d364774f', '2e0417cdd7f9495693596571801f5ca7')
      and service_name = 'cargo'
)
, client_attr as ( -- инфа о клиенте
    select lk.lk_client_id as corp_client_id,
           lk_client_name,
           trf.client_id is not null as target_tariff_flg,
           tariff_plan_series_name,
           coalesce(crm.manager_group,'B2B платформа') as manager_group,
           case when crm.market_segment in ('Рестораны и кафе','Цветы','E-grocery') then market_segment
                else 'Others' end as market_segment
    from snb_b2b.niksm_b2b_lk_client_service_info lk
      left join snb_b2b.niksm_b2b_contracts_info crm
        on contract_id = lk.contract_external_id
      left join trf
        on lk.lk_client_id = trf.client_id
    where lk.lk_service_name = 'cargo'
      --and crm.contract_id is null
)
, req as ( -- спец требования
    select taxi_order_id,
           bool_or(req_id = 'car_couriers') as car_couriers_flg,
           bool_or(req_id in ('thermobag_confirmed', 'thermobag_delivery', 'thermobox_option_on')) as thermobag_flg
    from snb_delivery.claim_segment_special_requirements
    where utc_created_dttm >= current_date-65-1
      and tariff_class_code = 'courier'
    group by taxi_order_id
)
, dlv as (
    select fct.corp_client_id,
           msk_order_created_dt,
           tariff_class_code,
           --
           sum(case when car_couriers_flg then delivery_point_cnt else 0 end) as car_couriers_deliveries_cnt,
           sum(case when car_couriers_flg then delivery_point_cnt else 0 end)::double precision
               / nullif(sum(delivery_point_cnt),0.) as car_couriers_deliveries_share,
           sum(case when car_couriers_flg and thermobag_flg then delivery_point_cnt else 0 end) as car_couriers_thermobag_deliveries_cnt,
           sum(case when car_couriers_flg and thermobag_flg then delivery_point_cnt else 0 end)::double precision
               / nullif(sum(delivery_point_cnt),0.) as car_couriers_thermobag_deliveries_share,
           sum(delivery_point_cnt) as deliveries_cnt,
           sum(gmv_amt * coalesce(currency_rate,1.)) as gmv_rub,
           sum(net_inflow_amt * coalesce(currency_rate,1.)) as net_inflow_rub,
           sum(b2b_decoupling_amt * coalesce(currency_rate,1.)) as b2b_decoupling_rub
    from taxi_cdm_marketplace.fct_order_metric fct
      left join req
        on req.taxi_order_id = fct.order_id
    where utc_order_created_dttm >= current_date-65-1
      and msk_order_created_dt between current_date-65 and current_date-1
      and success_order_flg
      and country_name_ru = 'Россия'
      and tariff_class_code in  ('courier', 'express')
    group by 1, 2, 3
)
,
     exclude_list as (
         select corp_client_id,
                1 as exclude_flg
         from snb_delivery.ferenec_car_couriers_pay_second_part
)

select msk_order_created_dt,
       tariff_class_code,
       market_segment,
       tariff_plan_series_name,
       coalesce(target_tariff_flg, FALSE) as target_tariff_flg,
       case when manager_group in ('INTERCO','ГПП 1','ГПП 2') then 'INTERCO+ГПП' else 'others' end as manager_group,
       case when exclude_flg = 1 then TRUE else FALSE end as exclude_flg,
       sum(car_couriers_deliveries_cnt) as car_couriers_deliveries_cnt_sum,
       sum(car_couriers_thermobag_deliveries_cnt) as car_couriers_thermobag_deliveries_cnt_sum,
       sum(deliveries_cnt) as deliveries_cnt,
       sum(gmv_rub) as gmv_rub,
       sum(net_inflow_rub) as net_inflow_rub,
       sum(b2b_decoupling_rub) as b2b_decoupling_rub
from dlv
  left join client_attr
    on dlv.corp_client_id = client_attr.corp_client_id
  left join exclude_list
    on exclude_list.corp_client_id = dlv.corp_client_id
group by 1, 2, 3, 4, 5, 6, 7
;


------------------------------------------------------------------------------------------------------------------------

with trf as (
    select corp_client_id as client_id,
           tariff_plan_name as tariff_plan_series_name
    from snb_b2b.dbcorp_client_tariff_plan_current
    where tariff_plan_series_id in
          ('a332ff55c1c64161a90bda46d0ad0a34', 'ec7753c8febe495caa132e6190ce1e31', 'ecf96b7eec8a4a1db4b8dc9cf6b15fae',
           'd3f2bff3d36245aa999c072fe73e9696', '8015578fdbb04989a0e06beabec5a5ef', 'e3fbe140c45647fb90bb7c9714048362',
           'b3e2a340beb44733b5347afa31857ab1', '9dc6852647e24d46915076f9336c39ec', 'a7d453e24d7d458d923c3c556c8b6558',
           '0ca32e88f2764459a119eaaa0bb1a652', '08c7c20b18b646c7bc1a91933181bdb0', 'aadf1f0f5fa54c49b884eda4d6e5bd02',
           '8f0b47a5295947988d5f4abd2cc73577', '95aa05b2c4d1482b825a2bb902f97ebe', '1acc79bf1dbe475097564b61d682a1dd',
           'aada3cf16c054b11ab6ccd799b4eef16', '9a4cd9a3f90f423eb675b43494b6517e', 'b7308dddf5a5466cb93fb39046244649',
           'a64a45c63e074819a4ee52d6db0f173b', '2e0e6eee37a04e6bb74f5e75d364774f', '2e0417cdd7f9495693596571801f5ca7')
      and service_name = 'cargo'
)
, client_attr as ( -- инфа о клиенте
    select lk.lk_client_id as corp_client_id,
           lk_client_name,
           trf.client_id is not null as target_tariff_flg,
           tariff_plan_series_name,
           coalesce(crm.manager_group,'B2B платформа') as manager_group,
           case when crm.market_segment in ('Рестораны и кафе','Цветы','E-grocery') then market_segment
                else 'Others' end as market_segment
    from snb_b2b.niksm_b2b_lk_client_service_info lk
      left join snb_b2b.niksm_b2b_contracts_info crm
        on contract_id = lk.contract_external_id
      left join trf
        on lk.lk_client_id = trf.client_id
    where lk.lk_service_name = 'cargo'
)
, req as ( -- спец требования
    select taxi_order_id,
           bool_or(req_id = 'car_couriers') as car_couriers_flg,
           bool_or(req_id in ('thermobag_confirmed', 'thermobag_delivery', 'thermobox_option_on')) as thermobag_flg
    from snb_delivery.claim_segment_special_requirements
    where utc_created_dttm >= '2021-11-30'
      and tariff_class_code = 'courier'
    group by taxi_order_id
)
select
--        fct.corp_client_id,
       msk_order_created_dt,
       tariff_class_code,
       coalesce(car_couriers_flg, False) as car_couriers_flg,
       coalesce(thermobag_flg, False) as thermobag_flg,
       client_attr.market_segment,
       client_attr.tariff_plan_series_name,
       coalesce(target_tariff_flg, FALSE) as target_tariff_flg,
       case when client_attr.manager_group in ('INTERCO','ГПП 1','ГПП 2') then 'INTERCO+ГПП' else 'others' end as manager_group,
       case when excl1.corp_client_id is not null then 1
            when excl2.corp_client_id is not null then 2
                else 0 end as exception_wave,
       srg.calc_id is not null as auto_courier_fee_flg,
       --
       sum(delivery_point_cnt) as deliveries_cnt,
       sum(gmv_amt * coalesce(currency_rate,1.)) as gmv_rub,
       sum(net_inflow_amt * coalesce(currency_rate,1.)) as net_inflow_rub,
       sum(b2b_decoupling_amt * coalesce(currency_rate,1.)) as b2b_decoupling_rub,
       sum(case when srg.calc_id is not null
                then (gmv_amt - COALESCE(surcharge * surcharge_beta, 0))/1.1*0.1 * coalesce(currency_rate,1.)
                else 0 end) as auto_courier_fee
from taxi_cdm_marketplace.fct_order_metric fct
  left join req
    on req.taxi_order_id = fct.order_id
  left join client_attr
    on fct.corp_client_id = client_attr.corp_client_id
  left join snb_delivery.ferenec_car_couriers_pay excl1
    on excl1.corp_client_id = fct.corp_client_id
    and excl1.exclude_flg = 1
  left join snb_delivery.ferenec_car_couriers_pay_second_part excl2
    on excl2.corp_client_id = fct.corp_client_id
  left join delivery_ods_cargo_claims.claim
    on claim.taxi_order_id = fct.order_id
  left join snb_b2b.niksm_temp_auto_courier_surcharge srg
    on 'cargo-pricing/v1/' || srg.calc_id = claim.final_pricing_calc_id
where utc_order_created_dttm >= '2021-11-30'
  and msk_order_created_dt between '2021-12-01' and current_date-1
  and success_order_flg
  and country_name_ru = 'Россия'
  and tariff_class_code in  ('courier', 'express')
group by 1,2,3,4,5,6,7,8,9,10;
